/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AnnotationIgnores {
    private static final Logger log = Logger.getLogger(AnnotationIgnores.class.getName());
    private final Map<Class<?>, Boolean> ignoreAnnotationDefaults = new HashMap();
    private final Map<Class<?>, Map<Member, Boolean>> ignoreAnnotationOnMember = new HashMap();
    private final Map<Class<?>, Boolean> ignoreAnnotationOnClass = new HashMap();
    private final Map<Class<?>, Map<Member, Map<Integer, Boolean>>> ignoreAnnotationOnParameter = new HashMap();
    private final Map<Member, Boolean> ignoreAnnotationOnReturn = new HashMap<Member, Boolean>();
    private final Map<Member, Boolean> ignoreAnnotationOnCrossParameter = new HashMap<Member, Boolean>();

    public void setDefaultIgnoreAnnotation(Class<?> clazz, Boolean b) {
        this.ignoreAnnotationDefaults.put(clazz, b == null || b != false);
    }

    public boolean getDefaultIgnoreAnnotation(Class<?> clazz) {
        return this.ignoreAnnotationDefaults.containsKey(clazz) && this.ignoreAnnotationDefaults.get(clazz) != false;
    }

    public void setIgnoreAnnotationsOnMember(Member member, boolean value) {
        Class<?> beanClass = member.getDeclaringClass();
        Map<Member, Boolean> memberList = this.ignoreAnnotationOnMember.get(beanClass);
        if (memberList == null) {
            memberList = new HashMap<Member, Boolean>();
            this.ignoreAnnotationOnMember.put(beanClass, memberList);
        }
        memberList.put(member, value);
    }

    public boolean isIgnoreAnnotations(Member member) {
        Class<?> clazz = member.getDeclaringClass();
        Map<Member, Boolean> ignoreAnnotationForMembers = this.ignoreAnnotationOnMember.get(clazz);
        if (ignoreAnnotationForMembers != null && ignoreAnnotationForMembers.containsKey(member)) {
            boolean value = ignoreAnnotationForMembers.get(member);
            if (value) {
                this.logMessage(member, clazz);
            }
            return value;
        }
        boolean ignoreAnnotation = this.getDefaultIgnoreAnnotation(clazz);
        if (ignoreAnnotation) {
            this.logMessage(member, clazz);
        }
        return ignoreAnnotation;
    }

    public void setIgnoreAnnotationsOnParameter(Member method, int i, boolean value) {
        Map<Integer, Boolean> indexes;
        Class<?> beanClass = method.getDeclaringClass();
        Map<Member, Map<Integer, Boolean>> memberList = this.ignoreAnnotationOnParameter.get(beanClass);
        if (memberList == null) {
            memberList = new HashMap<Member, Map<Integer, Boolean>>();
            this.ignoreAnnotationOnParameter.put(beanClass, memberList);
        }
        if ((indexes = memberList.get(method)) == null) {
            indexes = new HashMap<Integer, Boolean>();
            memberList.put(method, indexes);
        }
        indexes.put(i, value);
    }

    public boolean isIgnoreAnnotationOnParameter(Member m, int i) {
        Map<Integer, Boolean> indexes;
        Map<Member, Map<Integer, Boolean>> members = this.ignoreAnnotationOnParameter.get(m.getDeclaringClass());
        if (members != null && (indexes = members.get(m)) != null && indexes.containsKey(i)) {
            return indexes.get(i);
        }
        return false;
    }

    private void logMessage(Member member, Class<?> clazz) {
        String type = member instanceof Field ? "Field" : "Property";
        log.log(Level.FINEST, String.format("%s level annotations are getting ignored for %s.%s", type, clazz.getName(), member.getName()));
    }

    public void setIgnoreAnnotationsOnClass(Class<?> clazz, boolean b) {
        this.ignoreAnnotationOnClass.put(clazz, b);
    }

    public boolean isIgnoreAnnotations(Class<?> clazz) {
        boolean ignoreAnnotation = this.ignoreAnnotationOnClass.containsKey(clazz) ? this.ignoreAnnotationOnClass.get(clazz).booleanValue() : this.getDefaultIgnoreAnnotation(clazz);
        if (ignoreAnnotation) {
            log.log(Level.FINEST, String.format("Class level annotation are getting ignored for %s", clazz.getName()));
        }
        return ignoreAnnotation;
    }

    public void setIgnoreAnnotationOnReturn(Member method, boolean value) {
        this.ignoreAnnotationOnReturn.put(method, value);
    }

    public boolean isIgnoreAnnotationOnReturn(Member m) {
        Boolean value = this.ignoreAnnotationOnReturn.get(m);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setIgnoreAnnotationOnCrossParameter(Member method, boolean value) {
        this.ignoreAnnotationOnCrossParameter.put(method, value);
    }

    public boolean isIgnoreAnnotationOnCrossParameter(Member m) {
        Boolean value = this.ignoreAnnotationOnCrossParameter.get(m);
        if (value != null) {
            return value;
        }
        return false;
    }
}

