/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanCacheKey;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.exception.inject.NullableDependencyException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class InjectionResolver {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(InjectionResolver.class);
    private WebBeansContext webBeansContext;
    private Map<BeanCacheKey, Set<Bean<?>>> resolvedBeansByType = new ConcurrentHashMap();
    private Map<String, Set<Bean<?>>> resolvedBeansByName = new ConcurrentHashMap();

    public InjectionResolver(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void clearCaches() {
        this.resolvedBeansByName.clear();
        this.resolvedBeansByType.clear();
    }

    public void checkInjectionPointType(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define Type Variable generic type");
        }
    }

    public void checkInjectionPoint(InjectionPoint injectionPoint) {
        Bean bean;
        Set<Bean<?>> beanSet;
        Class clazz;
        WebBeansUtil.checkInjectionPointNamedQualifier(injectionPoint);
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " type can not be defined as Typevariable or Wildcard type!");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
        qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
        Class injectionPointClass = Object.class;
        Bean injectionPointBean = injectionPoint.getBean();
        if (injectionPointBean != null) {
            injectionPointClass = injectionPointBean.getBeanClass();
        }
        if (injectionPointClass == null && type instanceof Class) {
            injectionPointClass = (Class)type;
        }
        if ((beanSet = this.implResolveByType(injectionPoint.isDelegate(), type, injectionPointClass, qualifiers)).isEmpty() && qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
            this.createNewBean(injectionPoint, type, qualifiers, beanSet);
        }
        if ((bean = this.resolve(beanSet, injectionPoint)) == null) {
            InjectionExceptionUtil.throwUnsatisfiedResolutionException(clazz, injectionPoint, qualifiers);
        }
        if (clazz.isPrimitive() && bean.isNullable()) {
            throw new NullableDependencyException("Injection point type : " + injectionPoint + " type is primitive but resolved bean can have nullable objects!");
        }
    }

    public Bean<?> getInjectionPointBean(InjectionPoint injectionPoint) {
        Set<Bean<?>> beanSet;
        Class clazz;
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Set qualSet = injectionPoint.getQualifiers();
        Annotation[] qualifiers = qualSet.toArray(new Annotation[qualSet.size()]);
        if (this.isInstanceOrEventInjection(type)) {
            qualifiers = AnyLiteral.ARRAY;
        }
        if ((beanSet = this.implResolveByType(injectionPoint.isDelegate(), type, clazz, qualifiers)).isEmpty()) {
            if (qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
                this.createNewBean(injectionPoint, type, qualifiers, beanSet);
            } else {
                InjectionExceptionUtil.throwUnsatisfiedResolutionException(clazz, injectionPoint, qualifiers);
            }
        }
        return this.resolve(beanSet, injectionPoint);
    }

    private void createNewBean(InjectionPoint injectionPoint, Type type, Annotation[] qualifiers, Set<Bean<?>> beanSet) {
        New newQualifier = (New)qualifiers[0];
        Class newType = newQualifier.value() == New.class ? ClassUtil.getClass(type) : newQualifier.value();
        Set<Bean<?>> beans = this.implResolveByType(injectionPoint.isDelegate(), (Type)newType, injectionPoint.getBean().getBeanClass(), new Annotation[]{AnyLiteral.INSTANCE});
        if (beans.isEmpty()) {
            beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(newType));
        } else {
            for (Bean<?> bean : beans) {
                if (!(bean instanceof InjectionTargetBean)) continue;
                beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent((OwbBean)bean, newType));
                break;
            }
            if (beanSet.isEmpty()) {
                beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(newType));
            }
        }
    }

    private boolean isInstanceOrEventInjection(Type type) {
        ParameterizedType pt;
        Class clazz;
        boolean injectInstanceOrEventProvider = false;
        if (type instanceof ParameterizedType && ((clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Instance.class) || clazz.isAssignableFrom(Event.class))) {
            injectInstanceOrEventProvider = true;
        }
        return injectInstanceOrEventProvider;
    }

    public Set<Bean<?>> implResolveByName(String name) {
        Set<Bean<?>> specializedComponents;
        Asserts.assertNotNull(name, "name parameter can not be null");
        String cacheKey = name;
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByName.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        Set<Bean<?>> deployedComponents = this.webBeansContext.getBeanManagerImpl().getBeans();
        for (Bean<?> component : deployedComponents) {
            if (component.getName() == null || !component.getName().equals(name)) continue;
            resolvedComponents.add(component);
        }
        if ((resolvedComponents = this.findByEnabled(resolvedComponents)).size() > 1 && (specializedComponents = this.findSpecializedForNameResolution(resolvedComponents)).size() > 0) {
            resolvedComponents = specializedComponents;
        }
        if (resolvedComponents.isEmpty()) {
            this.resolvedBeansByName.put(cacheKey, Collections.EMPTY_SET);
        } else {
            this.resolvedBeansByName.put(cacheKey, resolvedComponents);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DEBUG_ADD_BYNAME_CACHE_BEANS", cacheKey);
        }
        return resolvedComponents;
    }

    private Set<Bean<?>> findByEnabled(Set<Bean<?>> resolvedComponents) {
        HashSet specializedComponents = new HashSet();
        if (resolvedComponents.size() > 0) {
            for (Bean<?> bean : resolvedComponents) {
                AbstractOwbBean component = (AbstractOwbBean)bean;
                if (!component.isEnabled()) continue;
                specializedComponents.add(component);
            }
        }
        return specializedComponents;
    }

    private Set<Bean<?>> findSpecializedForNameResolution(Set<Bean<?>> resolvedComponents) {
        HashSet specializedComponents = new HashSet();
        if (resolvedComponents.size() > 0) {
            for (Bean<?> bean : resolvedComponents) {
                AbstractOwbBean component = (AbstractOwbBean)bean;
                if (!component.isSpecializedBean()) continue;
                specializedComponents.add(component);
            }
        }
        return specializedComponents;
    }

    public Set<Bean<?>> implResolveByType(boolean isDelegate, Type injectionPointType, Annotation ... qualifiers) {
        return this.implResolveByType(isDelegate, injectionPointType, (Class<?>)null, qualifiers);
    }

    private String getBDABeansXMLPath(Class<?> injectionPointBeanClass) {
        if (injectionPointBeanClass == null) {
            return null;
        }
        ScannerService scannerService = this.webBeansContext.getScannerService();
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        return beansXMLScanner.getBeansXml(injectionPointBeanClass);
    }

    public Set<Bean<?>> implResolveByType(boolean isDelegate, Type injectionPointType, Class<?> injectionPointClass, Annotation ... qualifiers) {
        ScannerService scannerService = this.webBeansContext.getScannerService();
        String bdaBeansXMLFilePath = null;
        if (scannerService.isBDABeansXmlScanningEnabled()) {
            bdaBeansXMLFilePath = this.getBDABeansXMLPath(injectionPointClass);
        }
        boolean currentQualifier = false;
        if (this.isInstanceOrEventInjection(injectionPointType)) {
            qualifiers = AnyLiteral.ARRAY;
        } else if (qualifiers.length == 0) {
            qualifiers = DefaultLiteral.ARRAY;
            currentQualifier = true;
        }
        this.validateInjectionPointType(injectionPointType);
        BeanCacheKey cacheKey = new BeanCacheKey(isDelegate, injectionPointType, bdaBeansXMLFilePath, qualifiers);
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByType.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        boolean returnAll = false;
        if (injectionPointType.equals(Object.class) && currentQualifier) {
            returnAll = true;
        }
        block0: for (Bean<?> component : this.webBeansContext.getBeanManagerImpl().getBeans()) {
            if (!((OwbBean)component).isEnabled()) continue;
            if (returnAll) {
                resolvedComponents.add(component);
                continue;
            }
            for (Type componentApiType : component.getTypes()) {
                if (!GenericsUtil.satisfiesDependency(isDelegate, injectionPointType, componentApiType)) continue;
                resolvedComponents.add(component);
                continue block0;
            }
        }
        resolvedComponents = this.findByQualifier(resolvedComponents, injectionPointType, qualifiers);
        this.resolvedBeansByType.put(cacheKey, resolvedComponents);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DEBUG_ADD_BYTYPE_CACHE_BEANS", cacheKey);
        }
        return resolvedComponents;
    }

    private void validateInjectionPointType(Type injectionPointType) {
        if (injectionPointType instanceof TypeVariable || injectionPointType instanceof WildcardType || injectionPointType instanceof GenericArrayType) {
            throw new DefinitionException("Injection point cannot define Type Variable " + injectionPointType);
        }
        if (!(injectionPointType instanceof Class) && !(injectionPointType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Unsupported type " + injectionPointType.getClass());
        }
    }

    public Set<Bean<?>> findBySpecialization(Set<Bean<?>> result) {
        Iterator<Bean<?>> it = result.iterator();
        HashSet res = new HashSet();
        while (it.hasNext()) {
            AbstractOwbBean component = (AbstractOwbBean)it.next();
            if (!component.isSpecializedBean() || !component.isEnabled()) continue;
            res.add(component);
        }
        if (res.size() > 0) {
            return res;
        }
        return result;
    }

    public Set<Bean<?>> findByAlternatives(Set<Bean<?>> result) {
        return this.findByAlternatives(result, null);
    }

    public Set<Bean<?>> findByAlternatives(Set<Bean<?>> result, String bdaBeansXMLFilePath) {
        HashSet alternativeSet = new HashSet();
        HashSet enableSet = new HashSet();
        boolean containsAlternative = false;
        if (bdaBeansXMLFilePath != null) {
            for (Bean<?> bean : result) {
                if (bean.isAlternative()) {
                    if (!this.isAltBeanInInjectionPointBDA(bdaBeansXMLFilePath, bean)) continue;
                    if (!containsAlternative) {
                        containsAlternative = true;
                    }
                    alternativeSet.add(bean);
                    continue;
                }
                if (containsAlternative) continue;
                enableSet.add(bean);
            }
        } else {
            for (Bean<?> bean : result) {
                AbstractOwbBean temp;
                if (bean.isAlternative()) {
                    if (!containsAlternative) {
                        containsAlternative = true;
                    }
                    alternativeSet.add(bean);
                    continue;
                }
                if (containsAlternative || !(temp = (AbstractOwbBean)bean).isEnabled()) continue;
                enableSet.add(bean);
            }
        }
        if (containsAlternative) {
            return alternativeSet;
        }
        return enableSet;
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans, InjectionPoint injectionPoint) {
        Set<Bean<?>> set = this.resolveAll(beans);
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() > 1 && (set = this.findBySpecialization(set)).size() > 1) {
            InjectionExceptionUtil.throwAmbiguousResolutionException(set, null, injectionPoint, new Annotation[0]);
        }
        return set.iterator().next();
    }

    public <X> Set<Bean<? extends X>> resolveAll(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Bean<X>> set = new HashSet();
        for (Bean<X> bean : beans) {
            set.add(bean);
        }
        if ((set = this.findByAlternatives(set)) == null || set.isEmpty()) {
            return Collections.emptySet();
        }
        return set;
    }

    private boolean isAltBeanInInjectionPointBDA(String bdaBeansXMLFilePath, Bean<?> altBean) {
        ScannerService scannerService = this.webBeansContext.getScannerService();
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        Set definedAlternatives = beansXMLScanner.getAlternatives(bdaBeansXMLFilePath);
        if (definedAlternatives.contains(altBean.getBeanClass())) {
            return true;
        }
        Set definedStereotypes = beansXMLScanner.getStereotypes(bdaBeansXMLFilePath);
        for (Class stereoAnnotations : definedStereotypes) {
            if (!AnnotationUtil.hasClassAnnotation(altBean.getBeanClass(), stereoAnnotations)) continue;
            return true;
        }
        return false;
    }

    private Set<Bean<?>> findByQualifier(Set<Bean<?>> remainingSet, Type type, Annotation ... annotations) {
        Iterator<Bean<?>> it = remainingSet.iterator();
        HashSet result = new HashSet();
        while (it.hasNext()) {
            Bean<?> component = it.next();
            Set qTypes = component.getQualifiers();
            int i = 0;
            for (Annotation annot : annotations) {
                for (Annotation qualifier : qTypes) {
                    if (!annot.annotationType().equals(qualifier.annotationType()) || !AnnotationUtil.isCdiAnnotationEqual(qualifier, annot)) continue;
                    ++i;
                }
            }
            if (i != annotations.length) continue;
            result.add(component);
        }
        if (result.isEmpty() && annotations.length == 1 && New.class.equals(annotations[0].annotationType()) && Class.class.isInstance(type)) {
            result.add(this.webBeansContext.getWebBeansUtil().createNewComponent((Class)Class.class.cast(type)));
        }
        return result;
    }
}

