/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageEntry;
import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.FilterExpression;
import apache.rocketmq.v2.FilterType;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.impl.ClientManager;
import org.apache.rocketmq.client.java.impl.consumer.ReceiveMessageResult;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.message.GeneralMessageImpl;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.com.google.protobuf.Duration;
import org.apache.rocketmq.shaded.com.google.protobuf.Timestamp;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Durations;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Timestamps;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

abstract class ConsumerImpl
extends ClientImpl {
    static final Pattern CONSUMER_GROUP_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    private static final Logger log = LoggerFactory.getLogger(ConsumerImpl.class);
    private final String consumerGroup;

    ConsumerImpl(ClientConfiguration clientConfiguration, String consumerGroup, Set<String> topics) {
        super(clientConfiguration, topics);
        this.consumerGroup = consumerGroup;
    }

    protected ListenableFuture<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest request, MessageQueueImpl mq, java.time.Duration awaitDuration) {
        ArrayList messages = new ArrayList();
        try {
            Endpoints endpoints = mq.getBroker().getEndpoints();
            java.time.Duration tolerance = this.clientConfiguration.getRequestTimeout();
            java.time.Duration timeout = awaitDuration.plus(tolerance);
            ClientManager clientManager = this.getClientManager();
            RpcFuture<ReceiveMessageRequest, List<ReceiveMessageResponse>> future = clientManager.receiveMessage(endpoints, request, timeout);
            return Futures.transformAsync(future, responses -> {
                Status status = Status.newBuilder().setCode(Code.INTERNAL_SERVER_ERROR).setMessage("status was not set by server").build();
                Long transportDeliveryTimestamp = null;
                ArrayList<Message> messageList = new ArrayList<Message>();
                block5: for (ReceiveMessageResponse response : responses) {
                    switch (response.getContentCase()) {
                        case STATUS: {
                            status = response.getStatus();
                            continue block5;
                        }
                        case MESSAGE: {
                            messageList.add(response.getMessage());
                            continue block5;
                        }
                        case DELIVERY_TIMESTAMP: {
                            Timestamp deliveryTimestamp = response.getDeliveryTimestamp();
                            transportDeliveryTimestamp = Timestamps.toMillis(deliveryTimestamp);
                            continue block5;
                        }
                    }
                    log.warn("[Bug] Not recognized content for receive message response, mq={}, clientId={}, response={}", mq, this.clientId, response);
                }
                for (Message message : messageList) {
                    MessageViewImpl view = MessageViewImpl.fromProtobuf(message, mq, transportDeliveryTimestamp);
                    messages.add(view);
                }
                StatusChecker.check(status, future);
                ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(endpoints, messages);
                return Futures.immediateFuture(receiveMessageResult);
            }, MoreExecutors.directExecutor());
        }
        catch (Throwable t2) {
            log.error("[Bug] Exception raised during message receiving, mq={}, clientId={}", mq, this.clientId, t2);
            return Futures.immediateFailedFuture(t2);
        }
    }

    private AckMessageRequest wrapAckMessageRequest(MessageViewImpl messageView) {
        Resource topicResource = Resource.newBuilder().setResourceNamespace(this.clientConfiguration.getNamespace()).setName(messageView.getTopic()).build();
        AckMessageEntry entry = AckMessageEntry.newBuilder().setMessageId(messageView.getMessageId().toString()).setReceiptHandle(messageView.getReceiptHandle()).build();
        return AckMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).addEntries(entry).build();
    }

    private ChangeInvisibleDurationRequest wrapChangeInvisibleDuration(MessageViewImpl messageView, java.time.Duration invisibleDuration) {
        Resource topicResource = Resource.newBuilder().setResourceNamespace(this.clientConfiguration.getNamespace()).setName(messageView.getTopic()).build();
        return ChangeInvisibleDurationRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).setReceiptHandle(messageView.getReceiptHandle()).setInvisibleDuration(Durations.fromNanos(invisibleDuration.toNanos())).setMessageId(messageView.getMessageId().toString()).build();
    }

    protected RpcFuture<AckMessageRequest, AckMessageResponse> ackMessage(MessageViewImpl messageView) {
        RpcFuture<AckMessageRequest, AckMessageResponse> future;
        Endpoints endpoints = messageView.getEndpoints();
        final List<GeneralMessage> generalMessages = Collections.singletonList(new GeneralMessageImpl(messageView));
        final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.ACK);
        this.doBefore(context, generalMessages);
        try {
            AckMessageRequest request = this.wrapAckMessageRequest(messageView);
            java.time.Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
            future = this.getClientManager().ackMessage(endpoints, request, requestTimeout);
        }
        catch (Throwable t2) {
            future = new RpcFuture(t2);
        }
        Futures.addCallback(future, new FutureCallback<AckMessageResponse>(){

            @Override
            public void onSuccess(AckMessageResponse response) {
                Status status = response.getStatus();
                Code code = status.getCode();
                MessageHookPointsStatus hookPointsStatus = Code.OK.equals(code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, hookPointsStatus);
                ConsumerImpl.this.doAfter(context0, generalMessages);
            }

            @Override
            public void onFailure(Throwable t2) {
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                ConsumerImpl.this.doAfter(context0, generalMessages);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> changeInvisibleDuration(MessageViewImpl messageView, java.time.Duration invisibleDuration) {
        final Endpoints endpoints = messageView.getEndpoints();
        final List<GeneralMessage> generalMessages = Collections.singletonList(new GeneralMessageImpl(messageView));
        final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.CHANGE_INVISIBLE_DURATION);
        this.doBefore(context, generalMessages);
        ChangeInvisibleDurationRequest request = this.wrapChangeInvisibleDuration(messageView, invisibleDuration);
        java.time.Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
        RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> future = this.getClientManager().changeInvisibleDuration(endpoints, request, requestTimeout);
        final MessageId messageId = messageView.getMessageId();
        Futures.addCallback(future, new FutureCallback<ChangeInvisibleDurationResponse>(){

            @Override
            public void onSuccess(ChangeInvisibleDurationResponse response) {
                MessageHookPointsStatus hookPointsStatus;
                Status status = response.getStatus();
                Code code = status.getCode();
                MessageHookPointsStatus messageHookPointsStatus = hookPointsStatus = Code.OK.equals(code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                if (!Code.OK.equals(code)) {
                    log.error("Failed to change message invisible duration, messageId={}, endpoints={}, code={}, status message=[{}], clientId={}", messageId, endpoints, code, status.getMessage(), ConsumerImpl.this.clientId);
                }
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, hookPointsStatus);
                ConsumerImpl.this.doAfter(context0, generalMessages);
            }

            @Override
            public void onFailure(Throwable t2) {
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                ConsumerImpl.this.doAfter(context0, generalMessages);
                log.error("Exception raised while changing message invisible duration, messageId={}, endpoints={}, clientId={}", messageId, endpoints, ConsumerImpl.this.clientId, t2);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    protected Resource getProtobufGroup() {
        return Resource.newBuilder().setResourceNamespace(this.clientConfiguration.getNamespace()).setName(this.consumerGroup).build();
    }

    @Override
    public NotifyClientTerminationRequest wrapNotifyClientTerminationRequest() {
        return NotifyClientTerminationRequest.newBuilder().setGroup(this.getProtobufGroup()).build();
    }

    private apache.rocketmq.v2.FilterExpression wrapFilterExpression(FilterExpression filterExpression) {
        FilterExpression.Builder expressionBuilder = apache.rocketmq.v2.FilterExpression.newBuilder();
        expressionBuilder.setExpression(filterExpression.getExpression());
        switch (filterExpression.getFilterExpressionType()) {
            case SQL92: {
                expressionBuilder.setType(FilterType.SQL);
                break;
            }
            default: {
                expressionBuilder.setType(FilterType.TAG);
            }
        }
        return expressionBuilder.build();
    }

    ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression, java.time.Duration longPollingTimeout, String attemptId) {
        attemptId = null == attemptId ? UUID.randomUUID().toString() : attemptId;
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setFilterExpression(this.wrapFilterExpression(filterExpression)).setLongPollingTimeout(Durations.fromNanos(longPollingTimeout.toNanos())).setBatchSize(batchSize).setAutoRenew(true).setAttemptId(attemptId).build();
    }

    ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression, java.time.Duration invisibleDuration, java.time.Duration longPollingTimeout) {
        Duration duration = Durations.fromNanos(invisibleDuration.toNanos());
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setFilterExpression(this.wrapFilterExpression(filterExpression)).setLongPollingTimeout(Durations.fromNanos(longPollingTimeout.toNanos())).setBatchSize(batchSize).setAutoRenew(false).setInvisibleDuration(duration).build();
    }
}

