/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.definition;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.codec.protobuf.utils.ScopedProtobufSchemaManager;
import org.apache.servicecomb.codec.protobuf.utils.WrapSchema;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.swagger.invocation.response.ResponseMeta;

public class OperationProtobuf {
    private ScopedProtobufSchemaManager scopedProtobufSchemaManager;
    private OperationMeta operationMeta;
    private WrapSchema requestSchema;
    private WrapSchema responseSchema;

    public OperationProtobuf(ScopedProtobufSchemaManager scopedProtobufSchemaManager, OperationMeta operationMeta) {
        this.scopedProtobufSchemaManager = scopedProtobufSchemaManager;
        this.operationMeta = operationMeta;
        this.requestSchema = scopedProtobufSchemaManager.getOrCreateArgsSchema(operationMeta);
        Method method = operationMeta.getMethod();
        this.responseSchema = scopedProtobufSchemaManager.getOrCreateSchema(method.getGenericReturnType());
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public WrapSchema getRequestSchema() {
        return this.requestSchema;
    }

    public WrapSchema getResponseSchema() {
        return this.responseSchema;
    }

    public WrapSchema findResponseSchema(int statusCode) {
        if (Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)statusCode))) {
            return this.responseSchema;
        }
        ResponseMeta responseMeta = this.operationMeta.findResponseMeta(statusCode);
        return this.scopedProtobufSchemaManager.getOrCreateSchema((Type)responseMeta.getJavaType());
    }
}

