/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import java.util.List;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.ApplicationListener;

public class RibbonApplicationContextInitializer
implements ApplicationListener<ApplicationReadyEvent> {
    private final SpringClientFactory springClientFactory;
    private final List<String> clientNames;

    public RibbonApplicationContextInitializer(SpringClientFactory springClientFactory, List<String> clientNames) {
        this.springClientFactory = springClientFactory;
        this.clientNames = clientNames;
    }

    private void initialize() {
        if (this.clientNames != null) {
            for (String clientName : this.clientNames) {
                this.springClientFactory.getContext(clientName);
            }
        }
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.initialize();
    }
}

