/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.stream.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.stream.storage.NameAwarePurgableFileInputStream;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class FileStreamStorage
extends StreamStorage {
    private static final Logger log = LoggerFactory.getLogger(FileStreamStorage.class);
    volatile File file = null;
    volatile int threshold;
    volatile boolean append;
    volatile long maxCapacity = -1L;
    volatile long bytesWritten = 0L;
    volatile boolean deleteFilesOnClose = false;
    volatile boolean deleteFilesOnDispose = false;
    volatile ReadWriteStatus readWriteStatus;
    volatile StorageMode storageMode;
    volatile ByteArrayOutputStream byteArrayOutputStream;
    volatile FileOutputStream fileOutputStream;

    public static FileStreamStorage deferred(File file, int threshold) {
        return new FileStreamStorage(file, threshold, false);
    }

    public static FileStreamStorage directToFile(File file, boolean append) {
        return new FileStreamStorage(file, 0, append);
    }

    public FileStreamStorage deleteFilesOnClose() {
        this.deleteFilesOnClose = true;
        return this;
    }

    public FileStreamStorage deleteFilesOnDispose() {
        this.deleteFilesOnDispose = true;
        return this;
    }

    public FileStreamStorage maxCapacity(long maxCapacity) {
        this.checkMaxCapacityParameterIsValid(maxCapacity);
        this.maxCapacity = maxCapacity;
        return this;
    }

    protected FileStreamStorage(File file, int threshold, boolean deleteFilesOnClose, boolean deleteFilesOnDispose, boolean append, long maxCapacity) {
        this(file, threshold, append);
        this.checkMaxCapacityParameterIsValid(maxCapacity);
        this.maxCapacity = maxCapacity;
        this.deleteFilesOnClose = deleteFilesOnClose;
        this.deleteFilesOnDispose = deleteFilesOnDispose;
    }

    protected FileStreamStorage(File file, int threshold, boolean append) {
        this.file = file;
        this.threshold = threshold;
        this.readWriteStatus = ReadWriteStatus.WRITE;
        this.append = append;
        if (threshold <= 0) {
            this.storageMode = StorageMode.DISK;
            this.fileOutputStream = this.newFileOutputStream();
        } else {
            this.storageMode = StorageMode.MEMORY;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }
    }

    File getFile() {
        return this.file;
    }

    @Override
    public void write(int b) throws IOException {
        this.assertIsWritable();
        this.assertMaxCapacity(1L);
        if (this.checkThreshold(1)) {
            this.byteArrayOutputStream.write(b);
        } else {
            this.fileOutputStream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.assertIsWritable();
        this.assertMaxCapacity(len);
        if (this.checkThreshold(len)) {
            this.byteArrayOutputStream.write(b, off, len);
        } else {
            this.fileOutputStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.assertIsWritable();
        this.assertMaxCapacity(b.length);
        if (this.checkThreshold(b.length)) {
            this.byteArrayOutputStream.write(b);
        } else {
            this.fileOutputStream.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.assertIsWritable();
        if (this.fileOutputStream != null) {
            this.fileOutputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ReadWriteStatus.READ);
    }

    @Override
    public InputStream getInputStream() {
        if (this.readWriteStatus.equals((Object)ReadWriteStatus.READ)) {
            if (this.storageMode.equals((Object)StorageMode.MEMORY)) {
                return new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            }
            return this.newFileInputStream();
        }
        throw new IllegalStateException("The DeferredFileStreamStorage is still in write mode. Call the close() method when all the data has been written before asking for the InputStream.");
    }

    public boolean isInMemory() {
        return this.storageMode.equals((Object)StorageMode.MEMORY);
    }

    @Override
    public boolean dispose() {
        try {
            this.close(ReadWriteStatus.DISMISSED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.file == null || !this.file.exists() || this.deleteFilesOnDispose && this.file.delete();
    }

    void close(ReadWriteStatus newReadWriteStatus) throws IOException {
        this.readWriteStatus = newReadWriteStatus;
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
    }

    boolean checkThreshold(int lengthToWrite) throws IOException {
        if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() + lengthToWrite <= this.threshold) {
            return true;
        }
        if (this.isInMemory()) {
            this.switchToFile();
        }
        return false;
    }

    void assertIsWritable() {
        if (!this.readWriteStatus.equals((Object)ReadWriteStatus.WRITE)) {
            throw new IllegalStateException("OutputStream is closed");
        }
    }

    void switchToFile() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Switching to file");
        }
        this.fileOutputStream = new FileOutputStream(this.file);
        this.fileOutputStream.write(this.byteArrayOutputStream.toByteArray());
        this.fileOutputStream.flush();
        this.byteArrayOutputStream.reset();
        this.byteArrayOutputStream = null;
        this.storageMode = StorageMode.DISK;
    }

    FileOutputStream newFileOutputStream() {
        try {
            return new FileOutputStream(this.file, this.append);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the outputStream.", e);
        }
    }

    NameAwarePurgableFileInputStream newFileInputStream() {
        try {
            return new NameAwarePurgableFileInputStream(this.file, this.deleteFilesOnClose);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the inputStream.", e);
        }
    }

    void assertMaxCapacity(long numBytesToBeWritten) {
        if (this.maxCapacity == -1L) {
            return;
        }
        this.bytesWritten += numBytesToBeWritten;
        if (this.bytesWritten > this.maxCapacity) {
            throw new IllegalStateException("Exceeded the number of bytes allowed to be written to the storage. Max capacity: " + this.maxCapacity);
        }
    }

    void checkMaxCapacityParameterIsValid(long maxCapacity) {
        if (maxCapacity < -1L || maxCapacity == 0L) {
            throw new IllegalArgumentException("Invalid max size " + maxCapacity);
        }
    }

    static enum StorageMode {
        MEMORY,
        DISK;

    }

    static enum ReadWriteStatus {
        READ,
        WRITE,
        DISMISSED;

    }
}

