/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.sample.stream;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

public abstract class HystrixSampleSseServlet
extends HttpServlet {
    protected final Observable<String> sampleStream;
    private static final Logger logger = LoggerFactory.getLogger(HystrixSampleSseServlet.class);
    protected static final int DEFAULT_PAUSE_POLLER_THREAD_DELAY_IN_MS = 500;
    private final int pausePollerThreadDelayInMs;
    private static volatile boolean isDestroyed = false;

    protected HystrixSampleSseServlet(Observable<String> sampleStream) {
        this.sampleStream = sampleStream;
        this.pausePollerThreadDelayInMs = 500;
    }

    protected HystrixSampleSseServlet(Observable<String> sampleStream, int pausePollerThreadDelayInMs) {
        this.sampleStream = sampleStream;
        this.pausePollerThreadDelayInMs = pausePollerThreadDelayInMs;
    }

    protected abstract int getMaxNumberConcurrentConnectionsAllowed();

    protected abstract int getNumberCurrentConnections();

    protected abstract int incrementAndGetCurrentConcurrentConnections();

    protected abstract void decrementCurrentConcurrentConnections();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (isDestroyed) {
            response.sendError(503, "Service has been shut down.");
        } else {
            this.handleRequest(request, response);
        }
    }

    public static void shutdown() {
        isDestroyed = true;
    }

    public void init() throws ServletException {
        isDestroyed = false;
    }

    public void destroy() {
        isDestroyed = true;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final AtomicBoolean moreDataWillBeSent = new AtomicBoolean(true);
        Subscription sampleSubscription = null;
        int numberConnections = this.incrementAndGetCurrentConcurrentConnections();
        try {
            int maxNumberConnectionsAllowed = this.getMaxNumberConcurrentConnectionsAllowed();
            if (numberConnections > maxNumberConnectionsAllowed) {
                response.sendError(503, "MaxConcurrentConnections reached: " + maxNumberConnectionsAllowed);
            } else {
                response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                final PrintWriter writer = response.getWriter();
                sampleSubscription = this.sampleStream.observeOn(Schedulers.io()).subscribe((Subscriber)new Subscriber<String>(){

                    public void onCompleted() {
                        logger.error("HystrixSampleSseServlet: ({}) received unexpected OnCompleted from sample stream", (Object)((Object)((Object)this)).getClass().getSimpleName());
                        moreDataWillBeSent.set(false);
                    }

                    public void onError(Throwable e) {
                        moreDataWillBeSent.set(false);
                    }

                    public void onNext(String sampleDataAsString) {
                        if (sampleDataAsString != null) {
                            try {
                                writer.print("data: " + sampleDataAsString + "\n\n");
                                if (writer.checkError()) {
                                    moreDataWillBeSent.set(false);
                                }
                                writer.flush();
                            }
                            catch (Exception ex) {
                                moreDataWillBeSent.set(false);
                            }
                        }
                    }
                });
                while (moreDataWillBeSent.get() && !isDestroyed) {
                    try {
                        Thread.sleep(this.pausePollerThreadDelayInMs);
                        writer.print("ping: \n\n");
                        if (writer.checkError()) {
                            moreDataWillBeSent.set(false);
                        }
                        writer.flush();
                    }
                    catch (Exception ex) {
                        moreDataWillBeSent.set(false);
                    }
                }
            }
        }
        finally {
            this.decrementCurrentConcurrentConnections();
            if (sampleSubscription != null && !sampleSubscription.isUnsubscribed()) {
                sampleSubscription.unsubscribe();
            }
        }
    }
}

