/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.Extension;
import io.protostuff.compiler.model.GroupContainer;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.UserType;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class TypeRegistratorPostProcessor
implements ProtoContextPostProcessor {
    @Override
    public void process(ProtoContext context) {
        this.registerUserTypes(context);
    }

    private void registerUserTypes(ProtoContext context) {
        Proto proto = context.getProto();
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.addAll(proto.getMessages());
        for (Extension extension : proto.getDeclaredExtensions()) {
            messages.addAll(extension.getGroups());
        }
        for (Message message : messages) {
            message.setProto(proto);
            String fullyQualifiedName = proto.getNamespace() + message.getName();
            message.setFullyQualifiedName(fullyQualifiedName);
            context.register(fullyQualifiedName, message);
        }
        List<Enum> enums = proto.getEnums();
        for (Enum type : enums) {
            type.setProto(proto);
            String fullyQualifiedName = proto.getNamespace() + type.getName();
            type.setFullyQualifiedName(fullyQualifiedName);
            context.register(fullyQualifiedName, type);
        }
        List<Service> list = proto.getServices();
        for (Service type : list) {
            type.setProto(proto);
            String fullyQualifiedName = proto.getNamespace() + type.getName();
            type.setFullyQualifiedName(fullyQualifiedName);
            context.register(fullyQualifiedName, type);
        }
        for (Message message : messages) {
            this.registerNestedUserTypes(context, message);
        }
    }

    private void registerNestedUserTypes(ProtoContext context, UserTypeContainer parent) {
        ArrayList<Message> nestedMessages = new ArrayList<Message>();
        nestedMessages.addAll(parent.getMessages());
        if (parent instanceof GroupContainer) {
            nestedMessages.addAll(((GroupContainer)((Object)parent)).getGroups());
        }
        for (Extension extension : parent.getDeclaredExtensions()) {
            nestedMessages.addAll(extension.getGroups());
        }
        List<Enum> nestedEnums = parent.getEnums();
        Consumer<UserType> nestedTypeProcessor = type -> {
            type.setProto(context.getProto());
            String fullyQualifiedName = parent.getNamespace() + type.getName();
            type.setFullyQualifiedName(fullyQualifiedName);
            context.register(fullyQualifiedName, type);
        };
        nestedEnums.forEach(nestedTypeProcessor);
        nestedMessages.forEach(nestedTypeProcessor);
        nestedMessages.forEach(message -> this.registerNestedUserTypes(context, (UserTypeContainer)message));
    }
}

