/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.AnnotationUtils;

public class OpenAPIDefinitionProcessor
implements ClassAnnotationProcessor<OpenAPIDefinition> {
    @Override
    public Type getProcessType() {
        return OpenAPIDefinition.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OpenAPIDefinition definitionAnnotation) {
        OpenAPI swagger = swaggerGenerator.getOpenAPI();
        swagger.setServers(AnnotationUtils.serversModel(definitionAnnotation.servers()));
        swagger.setTags(AnnotationUtils.tagsModel(definitionAnnotation.tags()));
        swagger.setInfo(AnnotationUtils.infoModel(definitionAnnotation.info()));
        swagger.setExternalDocs(AnnotationUtils.externalDocumentationModel(definitionAnnotation.externalDocs()));
    }
}

