/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication;

import org.apache.servicecomb.authentication.AuthenticationBootListener;
import org.apache.servicecomb.authentication.consumer.ConsumerAuthFilter;
import org.apache.servicecomb.authentication.consumer.ConsumerTokenManager;
import org.apache.servicecomb.authentication.provider.AccessController;
import org.apache.servicecomb.authentication.provider.ProviderAuthFilter;
import org.apache.servicecomb.authentication.provider.ProviderTokenManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(value={"servicecomb.publicKey.accessControl.enabled"}, havingValue="true")
public class AuthenticationConfiguration {
    public static final String ACCESS_CONTROL_PREFIX = "servicecomb.publicKey.accessControl";
    public static final String ACCESS_CONTROL_ENABLED = "servicecomb.publicKey.accessControl.enabled";

    @Bean
    public ConsumerAuthFilter scbConsumerAuthFilter() {
        return new ConsumerAuthFilter();
    }

    @Bean
    public ProviderAuthFilter scbProviderAuthFilter() {
        return new ProviderAuthFilter();
    }

    @Bean
    public AuthenticationBootListener scbAuthenticationBootListener() {
        return new AuthenticationBootListener();
    }

    @Bean
    public ConsumerTokenManager scbConsumerTokenManager() {
        return new ConsumerTokenManager();
    }

    @Bean
    public ProviderTokenManager scbProviderTokenManager() {
        return new ProviderTokenManager();
    }

    @Bean
    public AccessController scbAccessController(Environment environment) {
        return new AccessController(environment);
    }
}

