/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXFormatter;
import org.apache.jackrabbit.vault.fs.io.DocViewFormat;
import org.apache.jackrabbit.vault.fs.io.Serializer;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;

public class DocViewSerializer
implements Serializer {
    private final AggregateImpl aggregate;

    public DocViewSerializer(Aggregate aggregate) {
        this.aggregate = (AggregateImpl)aggregate;
    }

    @Override
    public void writeContent(OutputStream out) throws IOException, RepositoryException {
        try (FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create(out, new DocViewFormat().getXmlOutputFormat());){
            DocViewSAXFormatter fmt = new DocViewSAXFormatter(this.aggregate, writer);
            this.aggregate.walk(fmt);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public SerializationType getType() {
        return SerializationType.XML_DOCVIEW;
    }
}

