/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.distribution.resources.impl.common.AbstractModifyingResourceProvider;
import org.apache.sling.distribution.resources.impl.common.SimpleModifiableResource;
import org.jetbrains.annotations.NotNull;

class SimpleModifiableValueMap
extends ModifiableValueMapDecorator
implements ModifiableValueMap {
    private final ResourceResolver resourceResolver;
    private final AbstractModifyingResourceProvider resourceProvider;
    private final SimpleModifiableResource resource;

    public SimpleModifiableValueMap(ResourceResolver resourceResolver, AbstractModifyingResourceProvider resourceProvider, SimpleModifiableResource resource) {
        super(resource.getProperties());
        this.resourceResolver = resourceResolver;
        this.resourceProvider = resourceProvider;
        this.resource = resource;
    }

    public Object put(String key, Object value) {
        Object result = super.put(key, value);
        this.changed();
        return result;
    }

    public Object remove(Object key) {
        Object result = super.remove(key);
        this.changed();
        return result;
    }

    public void putAll(@NotNull Map<? extends String, ?> t) {
        super.putAll(t);
        this.changed();
    }

    public void clear() {
        super.clear();
        this.changed();
    }

    private void changed() {
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        for (Map.Entry entry : this.entrySet()) {
            newProperties.put((String)entry.getKey(), entry.getValue());
        }
        this.resourceProvider.change(this.resourceResolver, this.resource.getPath(), newProperties);
    }
}

