/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.servlets;

import java.io.IOException;
import java.io.StringReader;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletPathsStrict;
import org.osgi.service.component.annotations.Component;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component(service={Servlet.class})
@SlingServletPathsStrict(paths={"/bin/sax"}, extensions={"xml"})
public class SaxServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final String XML_INPUT = "<content><name>SAX</name></content>";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            SimpleHandler handler = new SimpleHandler();
            parser.parse(new InputSource(new StringReader(XML_INPUT)), (DefaultHandler)handler);
            response.setContentType("text/plain");
            response.getWriter().write(handler.getValue());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    static class SimpleHandler
    extends DefaultHandler {
        private String value;
        private boolean matched;

        SimpleHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.matched = "name".equals(qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.matched) {
                this.value = new String(ch, start, length);
            }
        }

        public String getValue() {
            return this.value;
        }
    }
}

