/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.iterator;

import java.util.Iterator;
import org.apache.sling.query.api.internal.IteratorToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.impl.iterator.AbstractIterator;
import org.apache.sling.query.impl.util.LazyList;

public class ReverseIterator<T>
extends AbstractIterator<Option<T>> {
    private final Iterator<Option<T>> filtered;
    private final Iterator<Option<T>> original;

    public ReverseIterator(IteratorToIteratorFunction<T> function, Iterator<Option<T>> input) {
        LazyList<Option<T>> lazyList = new LazyList<Option<T>>(input);
        this.filtered = (Iterator)function.apply(lazyList.listIterator());
        this.original = lazyList.listIterator();
    }

    @Override
    protected Option<T> getElement() {
        if (this.original.hasNext()) {
            Option<T> originalElement = this.original.next();
            Option<T> filteredElement = null;
            if (this.filtered.hasNext()) {
                filteredElement = this.filtered.next();
            }
            if (filteredElement == null || filteredElement.isEmpty()) {
                return originalElement;
            }
            return Option.empty(originalElement.getArgumentId());
        }
        return null;
    }
}

