/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.external.ExternalizableInputStream;
import org.apache.sling.servlets.get.impl.helpers.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRenderer
implements Renderer {
    private static final String mimeSeparation = "SLING_MIME_BOUNDARY";
    private static final int ACCEPT_RANGES_THRESHOLD = 102400;
    private static final String ACCEPT_RANGES_HEADER = "Accept-Ranges";
    private static final String ACCEPT_RANGES_BYTES = "bytes";
    private static ArrayList<Range> FULL = new ArrayList(0);
    static final int IO_BUFFER_SIZE = 2048;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean index;
    private String[] indexFiles;
    private ServletContext context;

    public StreamRenderer(boolean index, String[] indexFiles, ServletContext context) {
        this.index = index;
        this.indexFiles = indexFiles;
        this.context = context;
    }

    @Override
    public void render(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        ResourceMetadata meta;
        long modifTime;
        boolean included = request.getAttribute("org.apache.sling.api.include.jakarta.servlet") != null;
        String ext = request.getRequestPathInfo().getExtension();
        if (ext != null && !ext.equals("res")) {
            request.getRequestProgressTracker().log("StreamRendererServlet does not support for extension " + ext);
            if (included || response.isCommitted()) {
                this.log.error("StreamRendererServlet does not support extension {}", (Object)ext);
            } else {
                response.sendError(404);
            }
            return;
        }
        Resource resource = request.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        if ("/".equals(request.getRequestPathInfo().getSuffix())) {
            this.renderDirectory(request, response, included);
            return;
        }
        if (!included && this.unmodified((HttpServletRequest)request, modifTime = (meta = resource.getResourceMetadata()).getModificationTime())) {
            response.setStatus(304);
            return;
        }
        if (resource.getResourceType().equals("nt:linkedFile")) {
            ValueMap vm = (ValueMap)resource.adaptTo(ValueMap.class);
            String actualResourcePath = (String)vm.get("jcr:content", String.class);
            resource = request.getResourceResolver().getResource(actualResourcePath);
            if (resource == null) {
                this.log.warn("Path {} does not exist", (Object)actualResourcePath);
                return;
            }
        }
        try (InputStream stream = (InputStream)resource.adaptTo(InputStream.class);){
            if (stream != null) {
                if (stream instanceof ExternalizableInputStream) {
                    response.sendRedirect(((ExternalizableInputStream)stream).getURI().toString());
                    return;
                }
                if (this.isHeadRequest((HttpServletRequest)request)) {
                    this.setContentLength((HttpServletResponse)response, resource.getResourceMetadata().getContentLength());
                    this.setHeaders(resource, response);
                    return;
                }
                this.streamResource(resource, stream, included, request, response);
            } else if (this.isRootResourceRequest(resource)) {
                this.renderDirectory(request, response, included);
            } else if (included || response.isCommitted()) {
                request.getRequestProgressTracker().log("StreamRendererServlet: Not redirecting with trailing slash, response is committed or request included");
                this.log.warn("StreamRendererServlet: Not redirecting with trailing slash, response is committed or request included");
            } else {
                String url = request.getResourceResolver().map((HttpServletRequest)request, resource.getPath()) + "/";
                response.sendRedirect(url);
            }
        }
    }

    private boolean isRootResourceRequest(Resource resource) {
        return "/".equals(resource.getPath()) || "/".equals(resource.getResourceResolver().map(resource.getPath()));
    }

    private boolean isHeadRequest(HttpServletRequest request) {
        return "HEAD".equals(request.getMethod());
    }

    private boolean unmodified(HttpServletRequest request, long modifTime) {
        if (modifTime > 0L) {
            long modTime = modifTime / 1000L;
            long ims = request.getDateHeader("If-Modified-Since") / 1000L;
            return modTime <= ims;
        }
        return false;
    }

    private void streamResource(Resource resource, InputStream stream, boolean included, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        ArrayList<Range> ranges;
        if (included) {
            ranges = FULL;
        } else {
            ranges = this.parseRange((HttpServletRequest)request, (HttpServletResponse)response, resource.getResourceMetadata());
            if (ranges == null) {
                return;
            }
            this.setHeaders(resource, response);
        }
        ServletOutputStream out = response.getOutputStream();
        if (ranges == FULL) {
            int rd;
            this.setContentLength((HttpServletResponse)response, resource.getResourceMetadata().getContentLength());
            byte[] buf = new byte[2048];
            while ((rd = stream.read(buf)) >= 0) {
                out.write(buf, 0, rd);
            }
        } else {
            response.setStatus(206);
            if (ranges.size() == 1) {
                Range range = ranges.get(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                this.setContentLength((HttpServletResponse)response, range.end - range.start + 1L);
                this.copy(stream, (OutputStream)out, range);
            } else {
                response.setContentType("multipart/byteranges; boundary=SLING_MIME_BOUNDARY");
                this.copy(resource, out, ranges.iterator());
            }
        }
    }

    private void renderDirectory(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response, boolean included) throws IOException {
        if (included || response.isCommitted()) {
            request.getRequestProgressTracker().log("StreamRendererServlet: Not rendering index, response is committed or request included");
            this.log.warn("StreamRendererServlet: Not rendering index, response is committed or request included");
            return;
        }
        Resource resource = request.getResource();
        ResourceResolver resolver = request.getResourceResolver();
        for (String index : this.indexFiles) {
            RequestDispatcher dispatcher;
            Resource fileRes = resolver.getResource(resource, index);
            if (fileRes == null || ResourceUtil.isSyntheticResource((Resource)fileRes)) continue;
            this.setHeaders(fileRes, response);
            if (this.isHeadRequest((HttpServletRequest)request)) {
                return;
            }
            RequestDispatcherOptions rdo = new RequestDispatcherOptions();
            rdo.setReplaceSuffix("");
            rdo.setReplaceSelectors("");
            if (index.indexOf(46) < 0) {
                String filePath = fileRes.getPath() + ".html";
                dispatcher = request.getRequestDispatcher(filePath, rdo);
            } else {
                dispatcher = request.getRequestDispatcher(fileRes, rdo);
            }
            try {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
            return;
        }
        if (this.index) {
            if (this.isHeadRequest((HttpServletRequest)request)) {
                this.setHeaders(resource, response);
                return;
            }
            this.renderIndex(resource, response);
        } else {
            response.sendError(403);
        }
    }

    private void setHeaders(Resource resource, SlingJakartaHttpServletResponse response) {
        String ct;
        ResourceMetadata meta = resource.getResourceMetadata();
        long modifTime = meta.getModificationTime();
        if (modifTime > 0L) {
            response.setDateHeader("Last-Modified", modifTime);
        }
        String defaultContentType = "application/octet-stream";
        String contentType = meta.getContentType();
        if ((contentType == null || "application/octet-stream".equals(contentType)) && (ct = this.context.getMimeType(resource.getPath())) != null) {
            contentType = ct;
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.setContentType(contentType);
        String encoding = meta.getCharacterEncoding();
        if (encoding != null) {
            response.setCharacterEncoding(encoding);
        }
        if (meta.getContentLength() > 102400L) {
            response.setHeader(ACCEPT_RANGES_HEADER, ACCEPT_RANGES_BYTES);
        }
    }

    private void setContentLength(HttpServletResponse response, long length) {
        if (length > 0L) {
            if (length < Integer.MAX_VALUE) {
                response.setContentLength((int)length);
            } else {
                response.setHeader("Content-Length", String.valueOf(length));
            }
        }
    }

    private void renderIndex(Resource resource, SlingJakartaHttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        String path = resource.getPath();
        PrintWriter pw = response.getWriter();
        pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>Index of " + path + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Index of " + path + "</h1>");
        pw.println("<pre>");
        pw.println("Name                               Last modified                   Size  Description");
        pw.println("<hr>");
        if (!"/".equals(path)) {
            pw.println("<a href='../'>../</a>                                                                 -     Parent");
        }
        Iterator children = resource.listChildren();
        while (children.hasNext()) {
            this.renderChild(pw, (Resource)children.next());
        }
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private void renderChild(PrintWriter pw, Resource resource) {
        String suffix;
        Object name = ResourceUtil.getName((String)resource.getPath());
        try (InputStream ins2 = (InputStream)resource.adaptTo(InputStream.class);){
            if (ins2 == null) {
                name = (String)name + "/";
            }
        }
        catch (IOException ins2) {
            // empty catch block
        }
        Object displayName = name;
        if (((String)displayName).length() >= 32) {
            displayName = ((String)displayName).substring(0, 29) + "...";
            suffix = "";
        } else {
            suffix = "                                               ".substring(0, 32 - ((String)displayName).length());
        }
        pw.printf("<a href='%s'>%s</a>%s", name, displayName, suffix);
        ResourceMetadata meta = resource.getResourceMetadata();
        long lastModified = meta.getModificationTime();
        pw.print("    " + String.valueOf(new Date(lastModified)) + "    ");
        long length = meta.getContentLength();
        if (length > 0L) {
            pw.print(length);
        } else {
            pw.print('-');
        }
        pw.println();
    }

    private void copy(Resource resource, ServletOutputStream ostream, Iterator<Range> ranges) throws IOException {
        String contentType = resource.getResourceMetadata().getContentType();
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            InputStream resourceInputStream = (InputStream)resource.adaptTo(InputStream.class);
            try (BufferedInputStream istream = new BufferedInputStream(resourceInputStream, 2048);){
                Range currentRange = ranges.next();
                ostream.println();
                ostream.println("--SLING_MIME_BOUNDARY");
                if (contentType != null) {
                    ostream.println("Content-Type: " + contentType);
                }
                ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
                ostream.println();
                try {
                    this.copy(istream, (OutputStream)ostream, currentRange);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
        }
        ostream.println();
        ostream.print("--SLING_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(InputStream istream, OutputStream ostream, Range range) throws IOException {
        long endIndex = range.end + 1L;
        this.log.debug("copy: Serving bytes: {}-{}", (Object)range.start, (Object)endIndex);
        StreamRenderer.staticCopyRange(istream, ostream, range.start, endIndex);
    }

    static void staticCopyRange(InputStream istream, OutputStream ostream, long start, long end) throws IOException {
        int len;
        int read;
        long position;
        long skipped;
        byte[] buffer = new byte[2048];
        for (position = 0L; position < start; position += skipped) {
            int len2;
            skipped = istream.skip(start - position);
            if (skipped != 0L || (skipped = (long)istream.read(buffer, 0, len2 = (int)Math.min(start - position, (long)buffer.length))) != -1L) continue;
            throw new IOException("Failed to skip " + start + " bytes; only skipped " + position + " bytes");
        }
        while (position < end && (read = istream.read(buffer, 0, len = (int)Math.min(end - position, (long)buffer.length))) != -1) {
            position += (long)read;
            ostream.write(buffer, 0, read);
        }
    }

    private ArrayList<Range> parseRange(HttpServletRequest request, HttpServletResponse response, ResourceMetadata metadata) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (headerValueTime == -1L) {
                return FULL;
            }
            if (metadata.getModificationTime() > headerValueTime + 1000L) {
                return FULL;
            }
        }
        if ((fileLength = metadata.getContentLength()) == 0L) {
            return FULL;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return FULL;
        }
        if (!rangeHeader.startsWith(ACCEPT_RANGES_BYTES)) {
            this.failParseRange(response, fileLength, rangeHeader);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                this.failParseRange(response, fileLength, rangeHeader);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    this.failParseRange(response, fileLength, rangeHeader);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                this.failParseRange(response, fileLength, rangeHeader);
                return null;
            }
            if (!currentRange.validate()) {
                this.failParseRange(response, fileLength, rangeHeader);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    private void failParseRange(HttpServletResponse response, long fileLength, String rangeHeader) throws IOException {
        this.log.error("parseRange: Cannot support range {}; sending 416", (Object)rangeHeader);
        response.addHeader("Content-Range", "bytes */" + fileLength);
        response.sendError(416);
    }

    protected class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }
}

