/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules;

import org.apache.sling.testing.clients.SystemPropertiesConfig;
import org.apache.sling.testing.clients.interceptors.UserAgentHolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CustomUserAgentRule
implements TestRule {
    private final String userAgent;
    private final boolean append;

    public CustomUserAgentRule(String userAgent) {
        this(userAgent, false);
    }

    public CustomUserAgentRule(String userAgent, boolean append) {
        this.userAgent = userAgent;
        this.append = append;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                CustomUserAgentRule.this.starting();
                try {
                    base.evaluate();
                }
                finally {
                    CustomUserAgentRule.this.finished();
                }
            }
        };
    }

    protected void starting() {
        String newUserAgent = this.userAgent;
        if (this.append) {
            String currentUserAgent = UserAgentHolder.get();
            if (currentUserAgent == null) {
                currentUserAgent = SystemPropertiesConfig.getDefaultUserAgent();
            }
            newUserAgent = currentUserAgent + " " + this.userAgent;
        }
        UserAgentHolder.set((String)newUserAgent);
    }

    protected void finished() {
        UserAgentHolder.reset();
    }
}

