/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui.filters;

import com.codahale.metrics.Meter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.storm.metric.StormMetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderResponseServletFilter
implements Filter {
    public static final Logger LOG = LoggerFactory.getLogger(HeaderResponseServletFilter.class);
    private final Meter webRequestMeter;
    private final Meter mainPageRequestMeter;

    public HeaderResponseServletFilter(StormMetricsRegistry metricsRegistry) {
        this.webRequestMeter = metricsRegistry.registerMeter("num-web-requests");
        this.mainPageRequestMeter = metricsRegistry.registerMeter("ui:num-main-page-http-requests");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.webRequestMeter.mark();
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        if (httpRequest.getPathInfo().equals("/index.html")) {
            this.mainPageRequestMeter.mark();
            httpResponse.addHeader("Cache-Control", "no-cache");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

