/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.metricstore.rocksdb.KeyType;

class StringMetadata {
    private List<KeyType> types = new ArrayList<KeyType>(1);
    private int stringId;
    private long lastTimestamp;

    StringMetadata(KeyType metadataType, Integer stringId, Long lastTimestamp) {
        this.types.add(metadataType);
        this.stringId = stringId;
        this.lastTimestamp = lastTimestamp;
    }

    int getStringId() {
        return this.stringId;
    }

    long getLastTimestamp() {
        return this.lastTimestamp;
    }

    List<KeyType> getMetadataTypes() {
        return this.types;
    }

    private void addKeyType(KeyType type) {
        if (!this.types.contains((Object)type)) {
            this.types.add(type);
        }
    }

    void update(Long metricTimestamp, KeyType type) {
        if (metricTimestamp > this.lastTimestamp) {
            this.lastTimestamp = metricTimestamp;
        }
        this.addKeyType(type);
    }
}

