/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.builtin;

import java.util.Date;
import org.apache.storm.trident.operation.BaseFilter;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debug
extends BaseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(Debug.class);
    private final String name;
    private boolean useLogger;

    public Debug() {
        this(false);
    }

    public Debug(boolean useLogger) {
        this.useLogger = useLogger;
        this.name = "DEBUG: ";
    }

    public Debug(String name) {
        this.name = "DEBUG(" + name + "): ";
    }

    @Override
    public boolean isKeep(TridentTuple tuple) {
        if (this.useLogger) {
            LOG.debug(tuple.toString());
        } else {
            System.out.println("<" + String.valueOf(new Date()) + "> " + this.name + tuple.toString());
        }
        return true;
    }
}

