/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.digest;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.sasl.PasswordProvider;

public class JassPasswordProvider
implements PasswordProvider {
    public static final String SYSPROP_SUPER_PASSWORD = "storm.SASLAuthenticationProvider.superPassword";
    private static final String USER_PREFIX = "user_";
    private Map<String, char[]> credentials = new ConcurrentHashMap<String, char[]>();

    public JassPasswordProvider(Map<String, Object> topoConf) throws IOException {
        Configuration configuration = ClientAuthUtils.getConfiguration(topoConf);
        if (configuration == null) {
            return;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("StormServer");
        if (configurationEntries == null) {
            String errorMessage = "Could not find a 'StormServer' entry in this configuration: Server cannot start.";
            throw new IOException(errorMessage);
        }
        this.credentials.clear();
        for (AppConfigurationEntry entry : configurationEntries) {
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> pair : options.entrySet()) {
                String key = pair.getKey();
                if (!key.startsWith(USER_PREFIX)) continue;
                String userName = key.substring(USER_PREFIX.length());
                this.credentials.put(userName, ((String)pair.getValue()).toCharArray());
            }
        }
        String superPassword = System.getProperty(SYSPROP_SUPER_PASSWORD);
        if (superPassword != null) {
            this.credentials.put("super", superPassword.toCharArray());
        }
    }

    @Override
    public Optional<char[]> getPasswordFor(String user) {
        return Optional.ofNullable(this.credentials.get(user));
    }

    @Override
    public boolean isImpersonationAllowed() {
        return true;
    }
}

