/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty12.ee10;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import io.dropwizard.metrics.jetty12.AbstractInstrumentedHandler;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import java.io.IOException;
import java.util.EventListener;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class InstrumentedEE10Handler
extends AbstractInstrumentedHandler {
    private AsyncDispatchesAwareServletRequestListener asyncDispatchesAwareServletRequestListener;

    public InstrumentedEE10Handler(MetricRegistry registry) {
        super(registry);
    }

    public InstrumentedEE10Handler(MetricRegistry registry, String prefix) {
        super(registry, prefix);
    }

    public InstrumentedEE10Handler(MetricRegistry registry, String prefix, ResponseMeteredLevel responseMeteredLevel) {
        super(registry, prefix, responseMeteredLevel);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.asyncDispatchesAwareServletRequestListener = new AsyncDispatchesAwareServletRequestListener(this.getAsyncDispatches());
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected void setupServletListeners(Request request, Response response) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (servletContextRequest == null) {
            return;
        }
        ServletChannelState servletChannelState = servletContextRequest.getServletRequestState();
        servletChannelState.addListener((AsyncListener)new InstrumentedAsyncListener(this.getAsyncTimeouts()));
        ServletContextHandler servletContextHandler = servletContextRequest.getServletContextHandler();
        servletContextHandler.addEventListener((EventListener)((Object)this.asyncDispatchesAwareServletRequestListener));
    }

    protected boolean isSuspended(Request request, Response response) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (servletContextRequest == null) {
            return false;
        }
        ServletChannelState servletChannelState = servletContextRequest.getServletRequestState();
        if (servletChannelState == null) {
            return false;
        }
        return servletChannelState.isSuspended();
    }

    private static class AsyncDispatchesAwareServletRequestListener
    implements ServletRequestListener {
        private final Meter asyncDispatches;

        private AsyncDispatchesAwareServletRequestListener(Meter asyncDispatches) {
            this.asyncDispatches = asyncDispatches;
        }

        public void requestInitialized(ServletRequestEvent sre) {
            ServletRequest servletRequest = sre.getServletRequest();
            if (!(servletRequest instanceof ServletApiRequest)) {
                return;
            }
            ServletApiRequest servletApiRequest = (ServletApiRequest)servletRequest;
            ServletContextHandler.ServletRequestInfo servletRequestInfo = servletApiRequest.getServletRequestInfo();
            ServletChannelState servletChannelState = servletRequestInfo.getServletRequestState();
            if (servletChannelState.isAsync() && !servletChannelState.isInitial()) {
                this.asyncDispatches.mark();
            }
        }
    }

    private static class InstrumentedAsyncListener
    implements AsyncListener {
        private final Meter asyncTimeouts;

        private InstrumentedAsyncListener(Meter asyncTimeouts) {
            this.asyncTimeouts = asyncTimeouts;
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.asyncTimeouts.mark();
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener((AsyncListener)this);
        }
    }
}

