/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.common;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.storm.common.CredentialKeyProvider;
import org.apache.storm.common.HadoopCredentialUtil;
import org.apache.storm.security.INimbusCredentialPlugin;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.apache.storm.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHadoopNimbusPluginAutoCreds
implements INimbusCredentialPlugin,
ICredentialsRenewer,
CredentialKeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHadoopNimbusPluginAutoCreds.class);
    public static final String CONFIG_KEY_RESOURCES = "resources";

    public void prepare(Map<String, Object> conf) {
        this.doPrepare(conf);
    }

    public void populateCredentials(Map<String, String> credentials, Map<String, Object> topologyConf, String topologyOwnerPrincipal) {
        try {
            List<String> configKeys = this.getConfigKeys(topologyConf);
            if (!configKeys.isEmpty()) {
                for (String configKey : configKeys) {
                    credentials.put(this.getCredentialKey(configKey), DatatypeConverter.printBase64Binary((byte[])this.getHadoopCredentials(topologyConf, configKey)));
                }
            } else {
                credentials.put(this.getCredentialKey(""), DatatypeConverter.printBase64Binary((byte[])this.getHadoopCredentials(topologyConf, topologyOwnerPrincipal)));
            }
            LOG.info("Tokens added to credentials map.");
        }
        catch (Exception e) {
            LOG.error("Could not populate credentials.", (Throwable)e);
        }
    }

    public void renew(Map<String, String> credentials, Map<String, Object> topologyConf, String topologyOwnerPrincipal) {
        this.doRenew(credentials, topologyConf, topologyOwnerPrincipal);
    }

    protected Set<Pair<String, Credentials>> getCredentials(Map<String, String> credentials, List<String> configKeys) {
        return HadoopCredentialUtil.getCredential(this, credentials, configKeys);
    }

    protected void fillHadoopConfiguration(Map topologyConf, String configKey, Configuration configuration) {
        Map config = (Map)topologyConf.get(configKey);
        LOG.info("TopoConf {}, got config {}, for configKey {}", new Object[]{ConfigUtils.maskPasswords((Map)topologyConf), ConfigUtils.maskPasswords((Map)config), configKey});
        if (config != null) {
            ArrayList resourcesToLoad = new ArrayList();
            for (Map.Entry entry : config.entrySet()) {
                if (((String)entry.getKey()).equals(CONFIG_KEY_RESOURCES)) {
                    resourcesToLoad.addAll((List)entry.getValue());
                    continue;
                }
                configuration.set((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            LOG.info("Resources to load {}", resourcesToLoad);
            for (String pathStr : resourcesToLoad) {
                configuration.addResource(new Path(Paths.get(pathStr, new String[0]).toUri()));
            }
        }
        LOG.info("Initializing UGI with config {}", (Object)configuration);
        UserGroupInformation.setConfiguration((Configuration)configuration);
    }

    protected abstract void doPrepare(Map<String, Object> var1);

    protected abstract String getConfigKeyString();

    protected abstract byte[] getHadoopCredentials(Map<String, Object> var1, String var2, String var3);

    protected abstract byte[] getHadoopCredentials(Map<String, Object> var1, String var2);

    protected abstract void doRenew(Map<String, String> var1, Map<String, Object> var2, String var3);

    protected List<String> getConfigKeys(Map<String, Object> conf) {
        String configKeyString = this.getConfigKeyString();
        List<String> configKeys = (List<String>)conf.get(configKeyString);
        return configKeys != null ? configKeys : Collections.emptyList();
    }
}

