/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.data.Id;
import org.apache.storm.shade.org.apache.zookeeper.server.ServerCnxn;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IPAuthenticationProvider.class);
    public static final String X_FORWARDED_FOR_HEADER_NAME = "X-Forwarded-For";
    public static final String USE_X_FORWARDED_FOR_KEY = "zookeeper.IPAuthenticationProvider.usexforwardedfor";
    private static final int IPV6_BYTE_LENGTH = 16;
    private static final int IPV6_SEGMENT_COUNT = 8;
    private static final int IPV6_SEGMENT_BYTE_LENGTH = 2;
    private static final int IPV6_SEGMENT_HEX_LENGTH = 4;
    private static final Pattern IPV6_PATTERN = Pattern.compile(":");
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\.");

    @Override
    public String getScheme() {
        return "ip";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        String id = cnxn.getRemoteSocketAddress().getAddress().getHostAddress();
        cnxn.addAuthInfo(new Id(this.getScheme(), id));
        return KeeperException.Code.OK;
    }

    @Override
    public List<Id> handleAuthentication(HttpServletRequest request, byte[] authData) {
        ArrayList<Id> ids = new ArrayList<Id>();
        String ip = IPAuthenticationProvider.getClientIPAddress(request);
        ids.add(new Id(this.getScheme(), ip));
        return Collections.unmodifiableList(ids);
    }

    private byte[] addr2Bytes(String addr) {
        if (IPV6_PATTERN.matcher(addr).find()) {
            return IPAuthenticationProvider.v6addr2Bytes(addr);
        }
        if (IPV4_PATTERN.matcher(addr).find()) {
            return this.v4addr2Bytes(addr);
        }
        LOG.warn("Input string does not resemble an IPv4 or IPv6 address: {}", (Object)addr);
        return null;
    }

    private byte[] v4addr2Bytes(String addr) {
        String[] parts = addr.split("\\.", -1);
        if (parts.length != 4) {
            return null;
        }
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            try {
                int v = Integer.parseInt(parts[i]);
                if (v < 0 || v > 255) {
                    return null;
                }
                b[i] = (byte)v;
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return b;
    }

    static byte[] v6addr2Bytes(String ipv6Addr) {
        try {
            return IPAuthenticationProvider.parseV6addr(ipv6Addr);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Fail to parse {} as IPv6 address: {}", (Object)ipv6Addr, (Object)e.getMessage());
            return null;
        }
    }

    static byte[] parseV6addr(String ipv6Addr) {
        String[] parts = ipv6Addr.split("::", -1);
        String[] segments1 = new String[]{};
        String[] segments2 = new String[]{};
        if (parts.length == 1) {
            segments1 = parts[0].split(":", -1);
            if (segments1.length != 8) {
                String reason = "wrong number of segments";
                throw new IllegalArgumentException(reason);
            }
        } else if (parts.length == 2) {
            if (!parts[0].isEmpty()) {
                segments1 = parts[0].split(":", -1);
            }
            if (!parts[1].isEmpty()) {
                segments2 = parts[1].split(":", -1);
            }
            if (segments1.length + segments2.length >= 8) {
                String reason = "too many segments";
                throw new IllegalArgumentException(reason);
            }
        } else {
            String reason = "too many '::'";
            throw new IllegalArgumentException(reason);
        }
        byte[] result = new byte[16];
        IPAuthenticationProvider.parseV6Segment(result, 0, segments1);
        IPAuthenticationProvider.parseV6Segment(result, 16 - segments2.length * 2, segments2);
        return result;
    }

    private static void parseV6Segment(byte[] addr, int i, String[] segments) {
        for (String segment : segments) {
            if (segment.isEmpty()) {
                throw new IllegalArgumentException("empty segment");
            }
            if (segment.length() > 4) {
                throw new IllegalArgumentException("segment too long");
            }
            try {
                int value = Integer.parseInt(segment, 16);
                addr[i++] = (byte)(value >> 8 & 0xFF);
                addr[i++] = (byte)(value & 0xFF);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid hexadecimal characters in segment: " + segment);
            }
        }
    }

    private void mask(byte[] b, int bits) {
        int start = bits / 8;
        int startMask = (1 << 8 - bits % 8) - 1;
        startMask ^= 0xFFFFFFFF;
        while (start < b.length) {
            int n = start++;
            b[n] = (byte)(b[n] & startMask);
            startMask = 0;
        }
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        LOG.trace("id: '{}' aclExpr:  {}", (Object)id, (Object)aclExpr);
        String[] parts = aclExpr.split("/", 2);
        byte[] aclAddr = this.addr2Bytes(parts[0]);
        if (aclAddr == null) {
            return false;
        }
        int bits = aclAddr.length * 8;
        if (parts.length == 2) {
            try {
                bits = Integer.parseInt(parts[1]);
                if (bits < 0 || bits > aclAddr.length * 8) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        this.mask(aclAddr, bits);
        byte[] remoteAddr = this.addr2Bytes(id);
        if (remoteAddr == null) {
            return false;
        }
        this.mask(remoteAddr, bits);
        if (remoteAddr.length != aclAddr.length) {
            return false;
        }
        for (int i = 0; i < remoteAddr.length; ++i) {
            if (remoteAddr[i] == aclAddr[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isValid(String id) {
        String[] parts = id.split("/", 2);
        byte[] aclAddr = this.addr2Bytes(parts[0]);
        if (aclAddr == null) {
            return false;
        }
        if (parts.length == 2) {
            try {
                int bits = Integer.parseInt(parts[1]);
                if (bits < 0 || bits > aclAddr.length * 8) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static String getClientIPAddress(HttpServletRequest request) {
        if (!Boolean.getBoolean(USE_X_FORWARDED_FOR_KEY)) {
            return request.getRemoteAddr();
        }
        String xForwardedForHeader = request.getHeader(X_FORWARDED_FOR_HEADER_NAME);
        if (xForwardedForHeader == null) {
            return request.getRemoteAddr();
        }
        return new StringTokenizer(xForwardedForHeader, ",").nextToken().trim();
    }
}

