/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.locale;

import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.struts2.ActionContext;
import org.apache.struts2.locale.LocaleProvider;

public class DefaultLocaleProvider
implements LocaleProvider {
    private static final Logger LOG = LogManager.getLogger(DefaultLocaleProvider.class);

    @Override
    public Locale getLocale() {
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            return ctx.getLocale();
        }
        LOG.debug("Action context not initialized");
        return null;
    }

    @Override
    public boolean isValidLocaleString(String localeStr) {
        Locale locale = this.toLocale(localeStr);
        return this.isValidLocale(locale);
    }

    @Override
    public boolean isValidLocale(Locale locale) {
        return locale != null && LocaleUtils.isAvailableLocale((Locale)locale);
    }

    @Override
    public Locale toLocale(String localeStr) {
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale((String)StringUtils.trimToNull((String)localeStr));
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Message)new ParameterizedMessage("Cannot convert [{}] to proper locale", (Object)localeStr), (Throwable)e);
        }
        return locale;
    }
}

