/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;

public class EllipseDrawer
extends ElementDrawer<JRPrintEllipse> {
    public EllipseDrawer(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void draw(Graphics2D grx, JRPrintEllipse ellipse, int offsetX, int offsetY) {
        int width = ellipse.getWidth();
        int height = ellipse.getHeight();
        if (ellipse.getMode() == ModeEnum.OPAQUE) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, width, height);
        }
        grx.setColor(ellipse.getLinePen().getLineColor());
        Stroke stroke = JRPenUtil.getStroke(ellipse.getLinePen(), 2);
        if (stroke != null) {
            grx.setStroke(stroke);
            AffineTransform oldTx = grx.getTransform();
            if (ellipse.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
                grx.translate((float)(ellipse.getX() + offsetX) - lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) - lineWidth / 3.0f);
                grx.scale(((float)width + 2.0f * lineWidth / 3.0f) / (float)width, ((float)height + 2.0f * lineWidth / 3.0f) / (float)height);
                grx.drawOval(0, 0, width, height);
                grx.setTransform(oldTx);
                grx.translate((float)(ellipse.getX() + offsetX) + lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) + lineWidth / 3.0f);
                if ((float)width > 2.0f * lineWidth / 3.0f) {
                    grx.scale(((float)width - 2.0f * lineWidth / 3.0f) / (float)width, 1.0);
                }
                if ((float)height > 2.0f * lineWidth / 3.0f) {
                    grx.scale(1.0, ((float)height - 2.0f * lineWidth / 3.0f) / (float)height);
                }
                grx.drawOval(0, 0, width, height);
            } else {
                grx.translate(ellipse.getX() + offsetX, ellipse.getY() + offsetY);
                grx.drawOval(0, 0, width, height);
            }
            grx.setTransform(oldTx);
        }
    }
}

