/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class ImageDrawer
extends ElementDrawer<JRPrintImage> {
    private final RenderersCache renderersCache;

    public ImageDrawer(JasperReportsContext jasperReportsContext, RenderersCache renderersCache) {
        super(jasperReportsContext);
        this.renderersCache = renderersCache;
    }

    @Override
    public void draw(Graphics2D grx, JRPrintImage printImage, int offsetX, int offsetY) throws JRException {
        block7: {
            if (printImage.getMode() == ModeEnum.OPAQUE) {
                grx.setColor(printImage.getBackcolor());
                grx.fillRect(printImage.getX() + offsetX, printImage.getY() + offsetY, printImage.getWidth(), printImage.getHeight());
            }
            InternalImageDrawer internalImageDrawer = new InternalImageDrawer(printImage, offsetX, offsetY);
            Renderable renderer = printImage.getRenderer();
            if (renderer != null && internalImageDrawer.availableImageWidth > 0 && internalImageDrawer.availableImageHeight > 0) {
                try {
                    internalImageDrawer.draw(grx, renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = RendererUtil.getInstance(this.getJasperReportsContext()).handleImageError(e, printImage.getOnErrorType());
                    if (onErrorRenderer == null) break block7;
                    internalImageDrawer.draw(grx, onErrorRenderer);
                }
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() != 0.0f) {
                this.drawPen(grx, printImage.getLinePen(), printImage, offsetX, offsetY);
            }
        } else {
            this.drawBox(grx, printImage.getLineBox(), printImage, offsetX, offsetY);
        }
    }

    private class InternalImageDrawer {
        private final JRPrintImage printImage;
        private final int offsetX;
        private final int offsetY;
        private final int availableImageWidth;
        private final int availableImageHeight;
        private final int topPadding;
        private final int leftPadding;
        private final int bottomPadding;
        private final int rightPadding;

        protected InternalImageDrawer(JRPrintImage printImage, int offsetX, int offsetY) {
            this.printImage = printImage;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.topPadding = printImage.getLineBox().getTopPadding();
            this.leftPadding = printImage.getLineBox().getLeftPadding();
            this.bottomPadding = printImage.getLineBox().getBottomPadding();
            this.rightPadding = printImage.getLineBox().getRightPadding();
            int tmpAvailableImageWidth = printImage.getWidth() - this.leftPadding - this.rightPadding;
            this.availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = printImage.getHeight() - this.topPadding - this.bottomPadding;
            this.availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
        }

        protected void draw(Graphics2D grx, Renderable renderer) throws JRException {
            if (renderer instanceof ResourceRenderer) {
                renderer = ImageDrawer.this.renderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            Graphics2DRenderable grxRenderer = ImageDrawer.this.renderersCache.getGraphics2DRenderable(renderer);
            switch (this.printImage.getScaleImage()) {
                case CLIP: {
                    this.drawClip(grx, grxRenderer);
                    break;
                }
                case FILL_FRAME: {
                    this.drawFillFrame(grx, grxRenderer);
                    break;
                }
                default: {
                    this.drawRetainShape(grx, grxRenderer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawClip(Graphics2D grx, Graphics2DRenderable renderer) throws JRException {
            DataRenderable dataRenderable;
            Dimension2D dimension;
            int translateX = 0;
            int translateY = 0;
            int renderWidth = 0;
            int renderHeight = 0;
            double angle = 0.0;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(ImageDrawer.this.getJasperReportsContext()) : null;
            if (dimension == null) {
                renderWidth = this.availableImageWidth;
                renderHeight = this.availableImageHeight;
            } else {
                renderWidth = (int)dimension.getWidth();
                renderHeight = (int)dimension.getHeight();
            }
            ExifOrientationEnum exifOrientation = ExifOrientationEnum.NORMAL;
            DataRenderable dataRenderable2 = dataRenderable = renderer instanceof DataRenderable ? (DataRenderable)((Object)renderer) : null;
            if (dataRenderable != null) {
                exifOrientation = ImageUtil.getExifOrientation(dataRenderable.getData(ImageDrawer.this.getJasperReportsContext()));
            }
            if (ExifOrientationEnum.LEFT == exifOrientation || ExifOrientationEnum.RIGHT == exifOrientation) {
                int t = renderWidth;
                renderWidth = renderHeight;
                renderHeight = t;
            }
            switch (this.printImage.getRotation()) {
                case LEFT: {
                    translateX = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageWidth - renderHeight));
                    translateY = this.availableImageHeight - (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageHeight - renderWidth));
                    angle = -1.5707963267948966;
                    break;
                }
                case RIGHT: {
                    translateX = this.availableImageWidth - (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageWidth - renderHeight));
                    translateY = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageHeight - renderWidth));
                    angle = 1.5707963267948966;
                    break;
                }
                case UPSIDE_DOWN: {
                    translateX = this.availableImageWidth - (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageWidth - renderWidth));
                    translateY = this.availableImageHeight - (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageHeight - renderHeight));
                    angle = Math.PI;
                    break;
                }
                default: {
                    translateX = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageWidth - renderWidth));
                    translateY = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageHeight - renderHeight));
                    angle = 0.0;
                }
            }
            Shape oldClipShape = grx.getClip();
            grx.clip(new Rectangle(this.printImage.getX() + this.leftPadding + this.offsetX, this.printImage.getY() + this.topPadding + this.offsetY, this.availableImageWidth, this.availableImageHeight));
            AffineTransform oldTransform = grx.getTransform();
            grx.translate(this.printImage.getX() + this.leftPadding + this.offsetX + translateX, this.printImage.getY() + this.topPadding + this.offsetY + translateY);
            grx.rotate(angle);
            try {
                renderer.render(ImageDrawer.this.getJasperReportsContext(), grx, new Rectangle(0, 0, renderWidth, renderHeight));
            }
            finally {
                grx.setTransform(oldTransform);
                grx.setClip(oldClipShape);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawFillFrame(Graphics2D grx, Graphics2DRenderable renderer) throws JRException {
            int translateX = 0;
            int translateY = 0;
            int renderWidth = this.availableImageWidth;
            int renderHeight = this.availableImageHeight;
            double angle = 0.0;
            switch (this.printImage.getRotation()) {
                case LEFT: {
                    translateX = 0;
                    translateY = this.availableImageHeight;
                    renderWidth = this.availableImageHeight;
                    renderHeight = this.availableImageWidth;
                    angle = -1.5707963267948966;
                    break;
                }
                case RIGHT: {
                    translateX = this.availableImageWidth;
                    translateY = 0;
                    renderWidth = this.availableImageHeight;
                    renderHeight = this.availableImageWidth;
                    angle = 1.5707963267948966;
                    break;
                }
                case UPSIDE_DOWN: {
                    translateX = this.availableImageWidth;
                    translateY = this.availableImageHeight;
                    renderWidth = this.availableImageWidth;
                    renderHeight = this.availableImageHeight;
                    angle = Math.PI;
                    break;
                }
            }
            AffineTransform oldTransform = grx.getTransform();
            grx.translate(this.printImage.getX() + this.leftPadding + this.offsetX + translateX, this.printImage.getY() + this.topPadding + this.offsetY + translateY);
            grx.rotate(angle);
            try {
                renderer.render(ImageDrawer.this.getJasperReportsContext(), grx, new Rectangle(0, 0, renderWidth, renderHeight));
            }
            finally {
                grx.setTransform(oldTransform);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawRetainShape(Graphics2D grx, Graphics2DRenderable renderer) throws JRException {
            DataRenderable dataRenderable;
            Dimension2D dimension;
            float normalWidth = 0.0f;
            float normalHeight = 0.0f;
            float ratioX = 1.0f;
            float ratioY = 1.0f;
            int translateX = 0;
            int translateY = 0;
            float renderWidth = 0.0f;
            float renderHeight = 0.0f;
            double angle = 0.0;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(ImageDrawer.this.getJasperReportsContext()) : null;
            if (dimension == null) {
                normalWidth = this.availableImageWidth;
                normalHeight = this.availableImageHeight;
            } else {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            ExifOrientationEnum exifOrientation = ExifOrientationEnum.NORMAL;
            DataRenderable dataRenderable2 = dataRenderable = renderer instanceof DataRenderable ? (DataRenderable)((Object)renderer) : null;
            if (dataRenderable != null) {
                exifOrientation = ImageUtil.getExifOrientation(dataRenderable.getData(ImageDrawer.this.getJasperReportsContext()));
            }
            if (ExifOrientationEnum.LEFT == exifOrientation || ExifOrientationEnum.RIGHT == exifOrientation) {
                float t = normalWidth;
                normalWidth = normalHeight;
                normalHeight = t;
            }
            switch (this.printImage.getRotation()) {
                case LEFT: {
                    ratioX = (float)this.availableImageWidth / normalHeight;
                    ratioY = (float)this.availableImageHeight / normalWidth;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    renderWidth = normalWidth * ratioX;
                    renderHeight = normalHeight * ratioY;
                    translateX = (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageWidth - renderHeight));
                    translateY = this.availableImageHeight - (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageHeight - renderWidth));
                    angle = -1.5707963267948966;
                    break;
                }
                case RIGHT: {
                    ratioX = (float)this.availableImageWidth / normalHeight;
                    ratioY = (float)this.availableImageHeight / normalWidth;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    renderWidth = normalWidth * ratioX;
                    renderHeight = normalHeight * ratioY;
                    translateX = this.availableImageWidth - (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageWidth - renderHeight));
                    translateY = (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageHeight - renderWidth));
                    angle = 1.5707963267948966;
                    break;
                }
                case UPSIDE_DOWN: {
                    ratioX = (float)this.availableImageWidth / normalWidth;
                    ratioY = (float)this.availableImageHeight / normalHeight;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    renderWidth = normalWidth * ratioX;
                    renderHeight = normalHeight * ratioY;
                    translateX = this.availableImageWidth - (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageWidth - renderWidth));
                    translateY = this.availableImageHeight - (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageHeight - renderHeight));
                    angle = Math.PI;
                    break;
                }
                default: {
                    ratioX = (float)this.availableImageWidth / normalWidth;
                    ratioY = (float)this.availableImageHeight / normalHeight;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    renderWidth = normalWidth * ratioX;
                    renderHeight = normalHeight * ratioY;
                    translateX = (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageWidth - renderWidth));
                    translateY = (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageHeight - renderHeight));
                    angle = 0.0;
                }
            }
            AffineTransform oldTransform = grx.getTransform();
            grx.translate(this.printImage.getX() + this.leftPadding + this.offsetX + translateX, this.printImage.getY() + this.topPadding + this.offsetY + translateY);
            grx.rotate(angle);
            try {
                renderer.render(ImageDrawer.this.getJasperReportsContext(), grx, new Rectangle(0, 0, (int)renderWidth, (int)renderHeight));
            }
            finally {
                grx.setTransform(oldTransform);
            }
        }
    }
}

