/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;

public class RabbitMQAMQPClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String queueName = System.getProperty("queueName");
        String mode = System.getProperty("mode");
        String routingKey = System.getProperty("routingKey");
        String exchangeName = System.getProperty("exchangeName");
        String quote = System.getProperty("payLoad");
        if (quote == null) {
            quote = "IBM";
        }
        String msg = "<m:placeOrder xmlns:m=\"http://services.samples\">\n    <m:order>\n        <m:price>" + RabbitMQAMQPClient.getRandom(100.0, 0.9, true) + "</m:price>\n        <m:quantity>" + (int)RabbitMQAMQPClient.getRandom(10000.0, 1.0, true) + "</m:quantity>\n        <m:symbol>" + quote + "</m:symbol>\n    </m:order>\n</m:placeOrder>";
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost("localhost");
        Connection connection = null;
        Channel channel = null;
        try {
            connection = factory.newConnection();
            channel = connection.createChannel();
            if (mode == null) {
                mode = "producer";
            }
            if ("producer".equals(mode)) {
                if (queueName != null) {
                    channel.basicPublish("", queueName, null, msg.getBytes());
                } else if (routingKey != null) {
                    if (exchangeName == null) {
                        exchangeName = "topic-exchange";
                    }
                    channel.basicPublish(exchangeName, routingKey, null, msg.getBytes());
                } else {
                    if (exchangeName == null) {
                        exchangeName = "subscriber-exchange";
                    }
                    channel.basicPublish(exchangeName, "", null, msg.getBytes());
                }
            } else {
                if (queueName == null) {
                    queueName = "ConsumerProxy";
                }
                QueueingConsumer consumer = new QueueingConsumer(channel);
                channel.basicConsume(queueName, true, (Consumer)consumer);
                QueueingConsumer.Delivery delivery = consumer.nextDelivery();
                String message = new String(delivery.getBody());
                System.out.println("[x] received '" + message + "'");
            }
            channel.close();
            connection.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (channel != null && channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    System.err.println("Error occurred while closing the channel:" + e.getMessage());
                }
            }
            if (connection != null && connection.isOpen()) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    System.err.println("Error occurred while closing the connection:" + e.getMessage());
                }
            }
        }
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }
}

