/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.securevault.SecretResolver;
import org.apache.synapse.securevault.secret.SecretCallbackHandler;
import org.apache.synapse.securevault.secret.SecretCallbackHandlerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SecretResolverFactory {
    public static SecretResolver create(OMElement configuration, boolean isCapLetter) {
        QName protectedTokensQName;
        QName pwProviderQName;
        QName pwManagerQName;
        String nsPrefix;
        SecretResolver secretResolver = new SecretResolver();
        QName parentQName = configuration.getQName();
        String nsURI = parentQName != null ? parentQName.getNamespaceURI() : "";
        String string = nsPrefix = parentQName != null ? parentQName.getPrefix() : "";
        if (!isCapLetter) {
            pwManagerQName = new QName(nsURI, "passwordManager", nsPrefix);
            pwProviderQName = new QName(nsURI, "passwordProvider", nsPrefix);
            protectedTokensQName = new QName(nsURI, "protectedTokens", nsPrefix);
        } else {
            pwManagerQName = new QName(nsURI, "PasswordManager", nsPrefix);
            pwProviderQName = new QName(nsURI, "PasswordProvider", nsPrefix);
            protectedTokensQName = new QName(nsURI, "ProtectedTokens", nsPrefix);
        }
        OMElement child = configuration.getFirstChildWithName(pwManagerQName);
        if (child == null) {
            return secretResolver;
        }
        OMElement passwordProviderElement = child.getFirstChildWithName(pwProviderQName);
        if (passwordProviderElement != null) {
            String value;
            OMElement protectedTokensElement;
            SecretResolverFactory.initPasswordManager(secretResolver, passwordProviderElement.getText());
            if (secretResolver.isInitialized() && (protectedTokensElement = child.getFirstChildWithName(protectedTokensQName)) != null && (value = protectedTokensElement.getText()) != null && value.trim().length() > 0) {
                ArrayList<String> protectedTokens = new ArrayList<String>(Arrays.asList(value.split(",")));
                for (String token : protectedTokens) {
                    secretResolver.addProtectedToken(token);
                }
            }
        }
        return secretResolver;
    }

    public static SecretResolver create(Properties properties, String propertyPrefix) {
        String protectedTokens;
        SecretResolver secretResolver = new SecretResolver();
        String prefix = propertyPrefix;
        if (propertyPrefix != null && !"".equals(propertyPrefix) && !propertyPrefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        SecretResolverFactory.initPasswordManager(secretResolver, properties.getProperty(prefix + "passwordProvider"));
        if (secretResolver.isInitialized() && (protectedTokens = properties.getProperty(prefix + "protectedTokens")) != null && !"".equals(protectedTokens.trim())) {
            ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(protectedTokens.split(",")));
            for (String token : tokens) {
                secretResolver.addProtectedToken(token);
            }
        }
        return secretResolver;
    }

    public static SecretResolver create(NamedNodeMap namedNodeMap) {
        String protectedTokens;
        Node protectedTokenAttr;
        String passwordProvider;
        SecretResolver secretResolver = new SecretResolver();
        Node namedItem = namedNodeMap.getNamedItem("passwordProvider");
        if (namedItem != null && (passwordProvider = namedItem.getNodeValue()) != null && passwordProvider.trim().length() > 0) {
            SecretResolverFactory.initPasswordManager(secretResolver, passwordProvider);
        }
        if (secretResolver.isInitialized() && (protectedTokenAttr = namedNodeMap.getNamedItem("protectedTokens")) != null && (protectedTokens = protectedTokenAttr.getNodeValue()) != null && protectedTokens.trim().length() > 0) {
            ArrayList<String> protectedTokenList = new ArrayList<String>(Arrays.asList(protectedTokens.split(",")));
            for (String token : protectedTokenList) {
                if (token == null || "".equals(token)) continue;
                secretResolver.addProtectedToken(token);
            }
        }
        return secretResolver;
    }

    private static void initPasswordManager(SecretResolver secretResolver, String provider) {
        SecretCallbackHandler callbackHandler = SecretCallbackHandlerFactory.createSecretCallbackHandler(provider);
        if (callbackHandler != null) {
            secretResolver.init(callbackHandler);
        }
    }
}

