/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.executors.config;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.commons.executors.InternalQueue;
import org.apache.synapse.commons.executors.MultiPriorityBlockingQueue;
import org.apache.synapse.commons.executors.NextQueueAlgorithm;
import org.apache.synapse.commons.executors.PRRNextQueueAlgorithm;
import org.apache.synapse.commons.executors.PriorityExecutor;

public class PriorityExecutorSerializer {
    public static OMElement serialize(OMElement parent, PriorityExecutor executor, String namespace) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement executorElement = PriorityExecutorSerializer.createElement("priorityExecutor", namespace);
        if (executor.getName() != null) {
            executorElement.addAttribute(fac.createOMAttribute("name", nullNS, executor.getName()));
        }
        if (executor.getBeforeExecuteHandler() != null) {
            executorElement.addAttribute(fac.createOMAttribute("beforeExecuteHandler", nullNS, executor.getBeforeExecuteHandler().getClass().getName()));
        }
        MultiPriorityBlockingQueue<Runnable> queue = executor.getQueue();
        NextQueueAlgorithm<Runnable> algo = queue.getNextQueueAlgorithm();
        OMElement queuesEle = PriorityExecutorSerializer.createElement("queues", namespace);
        if (!(algo instanceof PRRNextQueueAlgorithm)) {
            queuesEle.addAttribute(fac.createOMAttribute("nextQueue", nullNS, algo.getClass().getName()));
        }
        if (!queue.isFixedSizeQueues()) {
            queuesEle.addAttribute(fac.createOMAttribute("isFixedSize", nullNS, Boolean.toString(false)));
        }
        List<InternalQueue<Runnable>> intQueues = queue.getQueues();
        for (InternalQueue<Runnable> intQueue : intQueues) {
            OMElement queueEle = PriorityExecutorSerializer.createElement("queue", namespace);
            if (queue.isFixedSizeQueues()) {
                queueEle.addAttribute(fac.createOMAttribute("size", nullNS, Integer.toString(intQueue.getCapacity())));
            }
            queueEle.addAttribute(fac.createOMAttribute("priority", nullNS, Integer.toString(intQueue.getPriority())));
            queuesEle.addChild((OMNode)queueEle);
        }
        executorElement.addChild((OMNode)queuesEle);
        OMElement threadsEle = PriorityExecutorSerializer.createElement("threads", namespace);
        threadsEle.addAttribute(fac.createOMAttribute("max", nullNS, Integer.toString(executor.getMax())));
        threadsEle.addAttribute(fac.createOMAttribute("core", nullNS, Integer.toString(executor.getCore())));
        threadsEle.addAttribute(fac.createOMAttribute("keep-alive", nullNS, Integer.toString(executor.getKeepAlive())));
        executorElement.addChild((OMNode)threadsEle);
        if (parent != null) {
            parent.addChild((OMNode)executorElement);
        }
        return executorElement;
    }

    private static OMElement createElement(String name, String namespace) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        if (namespace == null) {
            return fac.createOMElement(new QName(name));
        }
        OMNamespace omNamespace = fac.createOMNamespace(namespace, "");
        return fac.createOMElement(name, omNamespace);
    }
}

