/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.synapse.transport.nhttp.AccessConstants;

public class AccessTimeUtil {
    private static final ThreadLocal<AccessDateStruct> currentDateStruct = new ThreadLocal<AccessDateStruct>(){

        @Override
        protected AccessDateStruct initialValue() {
            return new AccessDateStruct();
        }
    };

    private static String calculateTimeZoneOffset(long offset) {
        StringBuilder tz = new StringBuilder();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    public static String getTimeZone() {
        try {
            int offset = TimeZone.getDefault().getRawOffset();
            return AccessTimeUtil.calculateTimeZoneOffset(offset);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date getDate() {
        AccessDateStruct struct;
        long systime = System.currentTimeMillis();
        if (systime - (struct = currentDateStruct.get()).currentDate.getTime() > 1000L) {
            struct.currentDate.setTime(systime);
            struct.currentDateString = null;
        }
        return struct.currentDate;
    }

    private static AccessDateStruct getAccessDateStruct(Date date) {
        AccessDateStruct struct = currentDateStruct.get();
        if (struct.currentDateString == null) {
            StringBuilder current = new StringBuilder(32);
            current.append('[');
            current.append(struct.dayFormatter.format(date));
            current.append('/');
            current.append(AccessTimeUtil.lookup(struct.monthFormatter.format(date)));
            current.append('/');
            current.append(struct.yearFormatter.format(date));
            current.append(':');
            current.append(struct.timeFormatter.format(date));
            current.append(' ');
            current.append(AccessTimeUtil.getTimeZone());
            current.append(']');
            struct.currentDateString = current.toString();
        }
        return struct;
    }

    private static String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            AccessTimeUtil.handleThrowable(t);
            index = 0;
        }
        return AccessConstants.MONTHS[index];
    }

    public static String getAccessDate(Date date) {
        AccessDateStruct struct = AccessTimeUtil.getAccessDateStruct(date);
        return struct.currentDateString;
    }

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    private static class AccessDateStruct {
        private Date currentDate = new Date();
        private String currentDateString = null;
        private SimpleDateFormat dayFormatter = new SimpleDateFormat("dd");
        private SimpleDateFormat monthFormatter = new SimpleDateFormat("MM");
        private SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
        private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");

        public AccessDateStruct() {
            TimeZone tz = TimeZone.getDefault();
            this.dayFormatter.setTimeZone(tz);
            this.monthFormatter.setTimeZone(tz);
            this.yearFormatter.setTimeZone(tz);
            this.timeFormatter.setTimeZone(tz);
        }
    }
}

