/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Timer;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemMetadataProvider
extends AbstractReloadingMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(FilesystemMetadataProvider.class);
    private File metadataFile;

    public FilesystemMetadataProvider(File metadata) throws MetadataProviderException {
        this.setMetadataFile(metadata);
    }

    public FilesystemMetadataProvider(Timer backgroundTaskTimer, File metadata) throws MetadataProviderException {
        super(backgroundTaskTimer);
        this.setMetadataFile(metadata);
    }

    protected void setMetadataFile(File file) throws MetadataProviderException {
        if (!file.exists()) {
            throw new MetadataProviderException("Give metadata file, " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isFile()) {
            throw new MetadataProviderException("Give metadata file, " + file.getAbsolutePath() + " is not a file");
        }
        if (!file.canRead()) {
            throw new MetadataProviderException("Give metadata file, " + file.getAbsolutePath() + " is not readable");
        }
        this.metadataFile = file;
    }

    public boolean maintainExpiredMetadata() {
        return !this.requireValidMetadata();
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.setRequireValidMetadata(!maintain);
    }

    protected String getMetadataIdentifier() {
        return this.metadataFile.getAbsolutePath();
    }

    protected byte[] fetchMetadata() throws MetadataProviderException {
        try {
            DateTime metadataUpdateTime = new DateTime(this.metadataFile.lastModified(), (Chronology)ISOChronology.getInstanceUTC());
            if (this.getLastRefresh() == null || metadataUpdateTime.isAfter((ReadableInstant)this.getLastRefresh())) {
                return this.inputstreamToByteArray(new FileInputStream(this.metadataFile));
            }
            return null;
        }
        catch (IOException e) {
            String errMsg = "Unable to read metadata file " + this.metadataFile.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new MetadataProviderException(errMsg, e);
        }
    }
}

