/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics.view;

import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.view.Statistics;

public class InOutStatisticsView {
    private final Statistics inStatistics;
    private final Statistics outStatistics;
    private String resourceId;
    private String owner;
    private ComponentType componentType;

    public InOutStatisticsView(String id, String owner, ComponentType type) {
        this.resourceId = id;
        this.owner = owner;
        this.componentType = type;
        this.inStatistics = new Statistics(id);
        this.outStatistics = ComponentType.ENDPOINT.equals((Object)type) ? null : new Statistics(id);
    }

    public Statistics getInStatistics() {
        return this.inStatistics;
    }

    public Statistics getOutStatistics() {
        return this.outStatistics;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getOwner() {
        return this.owner;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Statistics Category : ").append((Object)this.componentType).append(" ]");
        sb.append("[ Owner Id :").append(this.owner).append(" ][ Resource ID : ").append(this.resourceId).append(" ]");
        if (this.inStatistics.getCount() != 0) {
            sb.append(" [ InFlow :  ").append(this.inStatistics.toString()).append(" ]");
        }
        if (this.outStatistics != null && this.outStatistics.getCount() != 0) {
            sb.append("[ OutFlow :  ").append(this.outStatistics.toString()).append(" ]");
        }
        return sb.toString();
    }
}

