/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.Member;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.RecipientListEndpoint;
import org.apache.synapse.mediators.Value;

public class RecipientListEndpointFactory
extends EndpointFactory {
    private static RecipientListEndpointFactory instance = new RecipientListEndpointFactory();
    private static final QName MEMBER = new QName("http://ws.apache.org/ns/synapse", "member");
    private static final QName DYNAMIC_SET = new QName("http://ws.apache.org/ns/synapse", "endpoints");

    private RecipientListEndpointFactory() {
    }

    public static RecipientListEndpointFactory getInstance() {
        return instance;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement recipientListElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "recipientlist"));
        if (recipientListElement != null) {
            RecipientListEndpoint recipientListEndpoint = new RecipientListEndpoint();
            OMAttribute name = epConfig.getAttribute(new QName("", "name"));
            if (name != null) {
                recipientListEndpoint.setName(name.getAttributeValue());
            }
            if (recipientListElement.getFirstChildWithName(XMLConfigConstants.ENDPOINT_ELT) != null) {
                if (recipientListElement.getChildrenWithName(MEMBER).hasNext()) {
                    String msg = "Invalid Synapse configuration. child elements";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                ArrayList<Endpoint> endpoints = this.getEndpoints(recipientListElement, recipientListEndpoint, properties);
                recipientListEndpoint.setChildren(endpoints);
            } else if (recipientListElement.getFirstChildWithName(MEMBER) != null) {
                if (recipientListElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT).hasNext()) {
                    String msg = "Invalid Synapse configuration. recipientListElement element cannot have both member & endpoint child elements";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                List<Member> members = this.getMembers(recipientListElement);
                recipientListEndpoint.setMembers(members);
            } else if (recipientListElement.getFirstChildWithName(DYNAMIC_SET) != null) {
                OMElement dynamicSetElement = recipientListElement.getFirstChildWithName(DYNAMIC_SET);
                Value dynamicEndpointSet = new ValueFactory().createValue("value", dynamicSetElement);
                String maxCacheStr = dynamicSetElement.getAttributeValue(new QName("max-cache"));
                int maxCache = 20;
                if (maxCacheStr != null) {
                    maxCache = Integer.parseInt(maxCacheStr);
                }
                recipientListEndpoint = new RecipientListEndpoint(maxCache);
                if (name != null) {
                    recipientListEndpoint.setName(name.getAttributeValue());
                }
                recipientListEndpoint.setDynamicEndpointSet(dynamicEndpointSet);
            }
            if (recipientListEndpoint.getChildren() == null && recipientListEndpoint.getMembers() == null && recipientListEndpoint.getDynamicEndpointSet() == null) {
                String msg = "A RecipientListEndpoint must have child/member elements, but the RecipientListEndpoint '" + recipientListEndpoint.getName() + "' does not have any child/member/dynamic endpoint elements.";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.processProperties(recipientListEndpoint, epConfig);
            return recipientListEndpoint;
        }
        return null;
    }

    private List<Member> getMembers(OMElement loadbalanceElement) {
        ArrayList<Member> members = new ArrayList<Member>();
        Iterator memberIter = loadbalanceElement.getChildrenWithName(MEMBER);
        while (memberIter.hasNext()) {
            String https;
            OMElement memberEle = (OMElement)memberIter.next();
            Member member = new Member(memberEle.getAttributeValue(new QName("hostName")), -1);
            String http = memberEle.getAttributeValue(new QName("httpPort"));
            if (http != null) {
                member.setHttpPort(Integer.parseInt(http));
            }
            if ((https = memberEle.getAttributeValue(new QName("httpsPort"))) != null && https.trim().length() != 0) {
                member.setHttpsPort(Integer.parseInt(https.trim()));
            }
            members.add(member);
        }
        return members;
    }
}

