/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;

public class TemplateEndpoint
extends AbstractEndpoint {
    private static final Log log = LogFactory.getLog(TemplateEndpoint.class);
    private String template = null;
    private Endpoint realEndpoint = null;
    private Map<String, String> parameters = new HashMap<String, String>();
    private String address = null;

    @Override
    public void send(MessageContext synCtx) {
        this.reLoadAndInitEndpoint(synCtx.getEnvironment());
        if (this.realEndpoint != null) {
            this.realEndpoint.send(synCtx);
        } else {
            this.informFailure(synCtx, 305100, "Couldn't find the endpoint with the name " + this.getName() + " & template : " + this.template);
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String name) {
        return this.parameters.get(name);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        super.init(synapseEnvironment);
        Template endpointTemplate = synapseEnvironment.getSynapseConfiguration().getEndpointTemplate(this.template);
        if (endpointTemplate == null) {
            log.warn((Object)("Template " + this.template + " cannot be found for the endpoint " + this.getName()));
            return;
        }
        this.reLoadAndInitEndpoint(synapseEnvironment);
    }

    private synchronized void reLoadAndInitEndpoint(SynapseEnvironment se) {
        boolean reLoad;
        SynapseConfiguration synCfg = se.getSynapseConfiguration();
        boolean bl = reLoad = this.realEndpoint == null;
        if (!reLoad) {
            Entry entry = synCfg.getEntryDefinition(this.template);
            if (entry != null && entry.isDynamic()) {
                if (!entry.isCached() || entry.isExpired()) {
                    reLoad = true;
                }
            } else {
                reLoad = false;
            }
        }
        if (reLoad) {
            Template eprTemplate;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading template endpoint with key : " + this.template));
            }
            if ((eprTemplate = synCfg.getEndpointTemplate(this.template)) != null) {
                this.realEndpoint = eprTemplate.create(this, synCfg.getProperties());
            } else {
                log.warn((Object)("Couldn't retrieve the endpoint template with the key:" + this.template));
            }
            if (this.realEndpoint != null && !this.realEndpoint.isInitialized()) {
                this.realEndpoint.init(se);
            }
        }
    }

    @Override
    public boolean readyToSend() {
        if (this.realEndpoint != null && this.realEndpoint.readyToSend()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Template Endpoint" + this.toString() + " is at ready state"));
            }
            return true;
        }
        log.warn((Object)("Template Endpoint " + this.toString() + " is not in a ready state to process message"));
        return false;
    }
}

