/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public class DBReportMediator
extends AbstractDBMediator {
    boolean useTransaction = false;

    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    public void setUseTransaction(boolean useTransaction) {
        this.useTransaction = useTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processStatement(Statement stmnt, MessageContext msgCtx) {
        SynapseLog synLog = this.getLog(msgCtx);
        Connection con = null;
        try {
            con = this.getDataSource().getConnection();
            PreparedStatement ps = this.getPreparedStatement(stmnt, con, msgCtx);
            con = ps.getConnection();
            int count = ps.executeUpdate();
            if (count > 0) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Inserted " + count + " row/s using statement : " + stmnt.getRawStatement());
                }
            } else if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("No rows were inserted for statement : " + stmnt.getRawStatement());
            }
            if (!this.useTransaction && !con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (SQLException e) {
            this.handleException("Error executing insert statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
        }
        catch (Exception e) {
            this.handleException("Error executing statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

