/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.util.Collection;
import java.util.Stack;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.TemplateParameter;
import org.apache.synapse.mediators.template.TemplateContext;

public class TemplateMediator
extends AbstractListMediator {
    private Collection<TemplateParameter> parameters;
    private String eipPatternName;
    private String fileName;
    private boolean initialized = false;

    public void setParameters(Collection<TemplateParameter> paramNames) {
        this.parameters = paramNames;
    }

    public Collection<TemplateParameter> getParameters() {
        return this.parameters;
    }

    public void setName(String name) {
        this.eipPatternName = name;
    }

    public String getName() {
        return this.eipPatternName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : EIP Sequence paramNames : " + this.parameters);
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        this.pushFuncContextTo(synCtx);
        boolean result = false;
        try {
            result = super.mediate(synCtx);
        }
        finally {
            this.popFuncContextFrom(synCtx);
        }
        return result;
    }

    private void pushFuncContextTo(MessageContext synCtx) {
        TemplateContext funcContext = new TemplateContext(this.eipPatternName, this.parameters);
        funcContext.setupParams(synCtx);
        Stack<TemplateContext> stack = (Stack<TemplateContext>)synCtx.getProperty("_SYNAPSE_FUNCTION_STACK");
        if (stack == null) {
            stack = new Stack<TemplateContext>();
            stack.push(funcContext);
            synCtx.setProperty("_SYNAPSE_FUNCTION_STACK", stack);
        } else {
            stack.push(funcContext);
        }
    }

    private void popFuncContextFrom(MessageContext synCtx) {
        Stack stack = (Stack)synCtx.getProperty("_SYNAPSE_FUNCTION_STACK");
        if (stack != null) {
            stack.pop();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public synchronized void init(SynapseEnvironment se) {
        if (!this.initialized) {
            super.init(se);
            this.initialized = true;
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.initialized) {
            super.destroy();
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

