/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Iterator;
import java.util.Set;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AlgorithmSuite;

public class AlgorithmSuiteValidator {
    private static final Log LOG = LogFactory.getLog(AlgorithmSuiteValidator.class);
    private final AlgorithmSuite algorithmSuite;

    public AlgorithmSuiteValidator(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public void checkSignatureMethod(String signatureMethod) throws WSSecurityException {
        Set<String> allowedSignatureMethods = this.algorithmSuite.getSignatureMethods();
        if (!allowedSignatureMethods.isEmpty() && !allowedSignatureMethods.contains(signatureMethod)) {
            LOG.debug((Object)("SignatureMethod " + signatureMethod + " does not match required values"));
            throw new WSSecurityException(3);
        }
    }

    public void checkC14nAlgorithm(String c14nAlgorithm) throws WSSecurityException {
        Set<String> allowedC14nAlgorithms = this.algorithmSuite.getC14nAlgorithms();
        if (!allowedC14nAlgorithms.isEmpty() && !allowedC14nAlgorithms.contains(c14nAlgorithm)) {
            LOG.debug((Object)("C14nMethod " + c14nAlgorithm + " does not match required value"));
            throw new WSSecurityException(3);
        }
    }

    public void checkSignatureAlgorithms(XMLSignature xmlSignature) throws WSSecurityException {
        String signatureMethod = xmlSignature.getSignedInfo().getSignatureMethod().getAlgorithm();
        this.checkSignatureMethod(signatureMethod);
        String c14nMethod = xmlSignature.getSignedInfo().getCanonicalizationMethod().getAlgorithm();
        this.checkC14nAlgorithm(c14nMethod);
        Iterator<Reference> i$ = xmlSignature.getSignedInfo().getReferences().iterator();
        while (i$.hasNext()) {
            Reference refObject;
            Reference reference = refObject = i$.next();
            String digestMethod = reference.getDigestMethod().getAlgorithm();
            Set<String> allowedDigestAlgorithms = this.algorithmSuite.getDigestAlgorithms();
            if (!allowedDigestAlgorithms.isEmpty() && !allowedDigestAlgorithms.contains(digestMethod)) {
                LOG.debug((Object)("DigestMethod " + digestMethod + " does not match required value"));
                throw new WSSecurityException(3);
            }
            for (int i = 0; i < reference.getTransforms().size(); ++i) {
                Transform transform = reference.getTransforms().get(i);
                String algorithm = transform.getAlgorithm();
                Set<String> allowedTransformAlgorithms = this.algorithmSuite.getTransformAlgorithms();
                if (allowedTransformAlgorithms.isEmpty() || allowedTransformAlgorithms.contains(algorithm)) continue;
                LOG.debug((Object)("Transform method " + algorithm + " does not match required value"));
                throw new WSSecurityException(3);
            }
        }
    }

    public void checkEncryptionKeyWrapAlgorithm(String keyWrapAlgorithm) throws WSSecurityException {
        Set<String> keyWrapAlgorithms = this.algorithmSuite.getKeyWrapAlgorithms();
        if (!keyWrapAlgorithms.isEmpty() && !keyWrapAlgorithms.contains(keyWrapAlgorithm)) {
            LOG.debug((Object)"The Key transport method does not match the requirement");
            throw new WSSecurityException(3);
        }
    }

    public void checkSymmetricEncryptionAlgorithm(String symmetricAlgorithm) throws WSSecurityException {
        Set<String> encryptionMethods = this.algorithmSuite.getEncryptionMethods();
        if (!encryptionMethods.isEmpty() && !encryptionMethods.contains(symmetricAlgorithm)) {
            LOG.debug((Object)"The encryption algorithm does not match the requirement");
            throw new WSSecurityException(3);
        }
    }

    public void checkAsymmetricKeyLength(X509Certificate x509Certificate) throws WSSecurityException {
        if (x509Certificate == null) {
            return;
        }
        this.checkAsymmetricKeyLength(x509Certificate.getPublicKey());
    }

    public void checkAsymmetricKeyLength(PublicKey publicKey) throws WSSecurityException {
        if (publicKey == null) {
            return;
        }
        if (publicKey instanceof RSAPublicKey) {
            int modulus = ((RSAPublicKey)publicKey).getModulus().bitLength();
            if (modulus < this.algorithmSuite.getMinimumAsymmetricKeyLength() || modulus > this.algorithmSuite.getMaximumAsymmetricKeyLength()) {
                LOG.debug((Object)"The asymmetric key length does not match the requirement");
                throw new WSSecurityException(3);
            }
        } else if (publicKey instanceof DSAPublicKey) {
            int length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
            if (length < this.algorithmSuite.getMinimumAsymmetricKeyLength() || length > this.algorithmSuite.getMaximumAsymmetricKeyLength()) {
                LOG.debug((Object)"The asymmetric key length does not match the requirement");
                throw new WSSecurityException(3);
            }
        } else {
            LOG.debug((Object)"An unknown public key was provided");
            throw new WSSecurityException(3);
        }
    }

    public void checkSymmetricKeyLength(int secretKeyLength) throws WSSecurityException {
        if (secretKeyLength < this.algorithmSuite.getMinimumSymmetricKeyLength() / 8 || secretKeyLength > this.algorithmSuite.getMaximumSymmetricKeyLength() / 8) {
            LOG.debug((Object)"The symmetric key length does not match the requirement");
            throw new WSSecurityException(3);
        }
    }

    public void checkSignatureDerivedKeyLength(int derivedKeyLength) throws WSSecurityException {
        int requiredKeyLength = this.algorithmSuite.getSignatureDerivedKeyLength();
        if (requiredKeyLength > 0 && derivedKeyLength / 8 != requiredKeyLength) {
            LOG.debug((Object)("The signature derived key length of " + derivedKeyLength + " does not match" + "the requirement of " + requiredKeyLength));
        }
    }

    public void checkEncryptionDerivedKeyLength(int derivedKeyLength) throws WSSecurityException {
        int requiredKeyLength = this.algorithmSuite.getEncryptionDerivedKeyLength();
        if (requiredKeyLength > 0 && derivedKeyLength / 8 != requiredKeyLength) {
            LOG.debug((Object)("The encryption derived key length of " + derivedKeyLength + " does not match" + "the requirement of " + requiredKeyLength));
        }
    }

    public void checkDerivedKeyAlgorithm(String algorithm) throws WSSecurityException {
        Set<String> derivedKeyAlgorithms = this.algorithmSuite.getDerivedKeyAlgorithms();
        if (!derivedKeyAlgorithms.isEmpty() && !derivedKeyAlgorithms.contains(algorithm)) {
            LOG.debug((Object)"The Derived Key Algorithm does not match the requirement");
            throw new WSSecurityException(3);
        }
    }
}

