/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class WeightedCrossEntropy
extends Lop {
    public static final String OPCODE = "mapwcemm";
    public static final String OPCODE_CP = "wcemm";
    private int _numThreads = 1;
    private WCeMMType _wcemmType = null;

    public WeightedCrossEntropy(Lop input1, Lop input2, Lop input3, Lop input4, Expression.DataType dt, Expression.ValueType vt, WCeMMType wt, LopProperties.ExecType et) {
        super(Lop.Type.WeightedCeMM, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        this.addInput(input4);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        input4.addOutput(this);
        this._wcemmType = wt;
        this.setupLopProperties(et);
    }

    private void setupLopProperties(LopProperties.ExecType et) {
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = WeightedCrossEntropy";
    }

    @Override
    public String getInstructions(int input1, int input2, int input3, int input4, int output) {
        return this.getInstructions(String.valueOf(input1), String.valueOf(input2), String.valueOf(input3), String.valueOf(input4), String.valueOf(output));
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.MR && this.getInputs().get(3).getDataType() == Expression.DataType.SCALAR) {
            sb.append(this.getInputs().get(3).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(3).prepInputOperand(input4));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._wcemmType);
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return this.getExecType() == LopProperties.ExecType.MR;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        int[] nArray;
        if (this.getExecType() == LopProperties.ExecType.MR) {
            int[] nArray2 = new int[2];
            nArray2[0] = 2;
            nArray = nArray2;
            nArray2[1] = 3;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = -1;
        }
        return nArray;
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum WCeMMType {
        BASIC,
        BASIC_EPS;


        public boolean hasFourInputs() {
            return this == BASIC_EPS;
        }
    }
}

