/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.decode;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.decode.Decoder;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DecoderPassThrough
extends Decoder {
    private static final long serialVersionUID = -8525203889417422598L;
    private int[] _dcCols = null;
    private int[] _srcCols = null;

    protected DecoderPassThrough(Expression.ValueType[] schema, int[] ptCols, int[] dcCols) {
        super(schema, ptCols);
        this._dcCols = dcCols;
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        out.ensureAllocatedColumns(in.getNumRows());
        int clen = Math.min(this._colList.length, out.getNumColumns());
        for (int i = 0; i < in.getNumRows(); ++i) {
            for (int j = 0; j < clen; ++j) {
                int srcColID = this._srcCols[j];
                int tgtColID = this._colList[j];
                double val = in.quickGetValue(i, srcColID - 1);
                out.set(i, tgtColID - 1, UtilFunctions.doubleToObject(this._schema[tgtColID - 1], val));
            }
        }
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (this._dcCols.length > 0) {
            this._srcCols = new int[this._colList.length];
            int ix1 = 0;
            int ix2 = 0;
            int off = 0;
            while (ix1 < this._colList.length) {
                if (ix2 >= this._dcCols.length || this._colList[ix1] < this._dcCols[ix2]) {
                    this._srcCols[ix1] = this._colList[ix1] + off;
                    ++ix1;
                    continue;
                }
                off += (int)meta.getColumnMetadata()[this._dcCols[ix2] - 1].getNumDistinct() - 1;
                ++ix2;
            }
        } else {
            this._srcCols = this._colList;
        }
    }
}

