/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.instructions.mr.AppendRInstruction;
import org.apache.sysml.runtime.instructions.mr.CtableInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixPackedCell;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.GMRCtableBuffer;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;

public class GMRReducer
extends ReduceBase
implements Reducer<MatrixIndexes, TaggedMatrixValue, MatrixIndexes, MatrixValue> {
    private MatrixValue realOutValue;
    private GMRCtableBuffer _buff;

    public void reduce(MatrixIndexes indexes, Iterator<TaggedMatrixValue> values, OutputCollector<MatrixIndexes, MatrixValue> out, Reporter reporter) throws IOException {
        long start = System.currentTimeMillis();
        this.commonSetup(reporter);
        this.cachedValues.reset();
        this.processAggregateInstructions(indexes, values);
        this.processReducerInstructionsInGMR(indexes);
        this.outputResultsFromCachedValuesForGMR(reporter);
        reporter.incrCounter((Enum)ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    protected void processReducerInstructionsInGMR(MatrixIndexes indexes) throws IOException {
        if (this.mixed_instructions == null) {
            return;
        }
        try {
            for (MRInstruction ins : this.mixed_instructions) {
                if (ins instanceof CtableInstruction) {
                    MatrixCharacteristics dim = (MatrixCharacteristics)this.dimensions.get(((CtableInstruction)ins).input1);
                    ((CtableInstruction)ins).processInstruction(this.valueClass, this.cachedValues, this.zeroInput, this._buff.getMapBuffer(), this._buff.getBlockBuffer(), dim.getRowsPerBlock(), dim.getColsPerBlock());
                    if (this._buff.getBufferSize() <= 4096) continue;
                    this._buff.flushBuffer(this.cachedReporter);
                    continue;
                }
                if (ins instanceof AppendRInstruction) {
                    MatrixCharacteristics dims1 = (MatrixCharacteristics)this.dimensions.get(((AppendRInstruction)ins).input1);
                    MatrixCharacteristics dims2 = (MatrixCharacteristics)this.dimensions.get(((AppendRInstruction)ins).input2);
                    long nbi1 = (long)Math.ceil((double)dims1.getRows() / (double)dims1.getRowsPerBlock());
                    long nbi2 = (long)Math.ceil((double)dims2.getRows() / (double)dims2.getRowsPerBlock());
                    long nbj1 = (long)Math.ceil((double)dims1.getCols() / (double)dims1.getColsPerBlock());
                    long nbj2 = (long)Math.ceil((double)dims2.getCols() / (double)dims2.getColsPerBlock());
                    if (nbi1 < indexes.getRowIndex() && nbi2 < indexes.getRowIndex() || nbj1 < indexes.getColumnIndex() && nbj2 < indexes.getColumnIndex()) continue;
                    this.processOneInstruction(ins, this.valueClass, this.cachedValues, this.tempValue, this.zeroInput);
                    continue;
                }
                this.processOneInstruction(ins, this.valueClass, this.cachedValues, this.tempValue, this.zeroInput);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void outputResultsFromCachedValuesForGMR(Reporter reporter) throws IOException {
        for (int i = 0; i < this.resultIndexes.length; ++i) {
            byte output = this.resultIndexes[i];
            ArrayList<IndexedMatrixValue> outValueList = this.cachedValues.get(output);
            if (outValueList == null) continue;
            for (IndexedMatrixValue outValue : outValueList) {
                if (this.valueClass.equals(MatrixPackedCell.class)) {
                    this.realOutValue.copy(outValue.getValue());
                    this.collectOutput_N_Increase_Counter(outValue.getIndexes(), this.realOutValue, i, reporter);
                    continue;
                }
                this.collectOutput_N_Increase_Counter(outValue.getIndexes(), outValue.getValue(), i, reporter);
            }
        }
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        if (this.containsTernaryInstruction()) {
            this._buff = new GMRCtableBuffer(this.collectFinalMultipleOutputs, this.dimsKnownForTernaryInstructions());
            this._buff.setMetadataReferences(this.resultIndexes, this.resultsNonZeros, this.resultDimsUnknown, this.resultsMaxRowDims, this.resultsMaxColDims);
            this.prepareMatrixCharacteristicsTernaryInstruction(job);
        }
        try {
            this.realOutValue = (MatrixValue)this.valueClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.valueClass.equals(MatrixCell.class)) {
            this.valueClass = MatrixPackedCell.class;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.containsTernaryInstruction()) {
            this._buff.flushBuffer(this.cachedReporter);
        }
        super.close();
    }
}

