/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.conv2d_depthwise.Backward_output;
import org.apache.sysml.scripts.nn.layers.conv2d_depthwise.Forward_output;
import org.apache.sysml.scripts.nn.layers.conv2d_depthwise.Init_output;

public class Conv2d_depthwise
extends Script {
    public Conv2d_depthwise() {
        String string = "scripts/nn/layers/conv2d_depthwise.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/layers/conv2d_depthwise.dml') as mlcontextns;[W, b] = mlcontextns::init(C, M, Hf, Wf);";
        Script script = new Script(string);
        script.in("C", object).in("M", object2).in("Hf", object3).in("Wf", object4).out("W").out("b");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int C, int M, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - M: Number of filters per input channel (i.e. depth multiplier).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C, M*Hf*Wf).\n   *  - b: Biases, of shape (C*M, 1).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int C, int M, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - M: Number of filters per input channel (i.e. depth multiplier).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C, M*Hf*Wf).\n   *  - b: Biases, of shape (C*M, 1).\n   */\n  # Note: Each filter is applied to a volume of depth 1, so we only use Hf*Wf in the scaling factor.\n  W = rand(rows=C, cols=M*Hf*Wf, pdf=\"normal\") * sqrt(2.0/(Hf*Wf))\n  b = matrix(0, rows=C*M, cols=1)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) {
        String string = "source('scripts/nn/layers/conv2d_depthwise.dml') as mlcontextns;[out, Hout, Wout] = mlcontextns::forward(X, W, b, Hin, Win, M, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).in("Hin", object4).in("Win", object5).in("M", object6).in("Hf", object7).in("Wf", object8).in("strideh", object9).in("stridew", object10).in("padh", object11).in("padw", object12).out("out").out("Hout").out("Wout");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        long l = mLResults.getLong("Hout");
        long l2 = mLResults.getLong("Wout");
        Forward_output forward_output = new Forward_output(matrix, l, l2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int Hin, int Win, int M, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D depthwise spatial convolutional\n   * layer with C*M filters of depth 1.  The input data has N examples,\n   * each represented as a 3D volume with C channels unrolled into a\n   * single vector.  For each group of M filters, a 2D convolution is\n   * applied to 1 unique input channel, yielding M output channels per\n   * input channel.  The resulting C groups of M output channels are\n   * then concatenated together channel-wise into a single volume of C*M\n   * output channels.  This can also be interpreted as C filters of\n   * depth 1 that expand each input channel to M output channels, where\n   * M is a \"depth multiplier\".\n   *\n   * Although there are C*M filters of depth 1, instead of storing W as\n   * shape `(C*M, 1*Hf*Wf)`, we reshape it to `(C, M*Hf*Wf)` for\n   * performance reasons.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, M*Hf*Wf).\n   *  - b: Biases, of shape (C*M, 1).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Number of filters per input channel (i.e. depth multiplier).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      For same output height as input, set `padh = (Hf - 1) / 2`,\n   *      assuming `strideh = 1`.\n   *      More generally, `padh = (Hin*(strideh-1) + Hf - strideh) / 2`\n   *      preserves the spatial dimensions of the input.\n   *  - padw: Padding for left and right sides.\n   *      For same output width as input, set `padw = (Wf - 1) / 2`,\n   *      assuming `stridew = 1`.\n   *      More generally, `padw = (Win*(stridew-1) + Wf - stridew) / 2`\n   *      preserves the spatial dimensions of the input.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int Hin, int Win, int M, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D depthwise spatial convolutional\n   * layer with C*M filters of depth 1.  The input data has N examples,\n   * each represented as a 3D volume with C channels unrolled into a\n   * single vector.  For each group of M filters, a 2D convolution is\n   * applied to 1 unique input channel, yielding M output channels per\n   * input channel.  The resulting C groups of M output channels are\n   * then concatenated together channel-wise into a single volume of C*M\n   * output channels.  This can also be interpreted as C filters of\n   * depth 1 that expand each input channel to M output channels, where\n   * M is a \"depth multiplier\".\n   *\n   * Although there are C*M filters of depth 1, instead of storing W as\n   * shape `(C*M, 1*Hf*Wf)`, we reshape it to `(C, M*Hf*Wf)` for\n   * performance reasons.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, M*Hf*Wf).\n   *  - b: Biases, of shape (C*M, 1).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Number of filters per input channel (i.e. depth multiplier).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *      For same output height as input, set `padh = (Hf - 1) / 2`,\n   *      assuming `strideh = 1`.\n   *      More generally, `padh = (Hin*(strideh-1) + Hf - strideh) / 2`\n   *      preserves the spatial dimensions of the input.\n   *  - padw: Padding for left and right sides.\n   *      For same output width as input, set `padw = (Wf - 1) / 2`,\n   *      assuming `stridew = 1`.\n   *      More generally, `padw = (Win*(stridew-1) + Wf - stridew) / 2`\n   *      preserves the spatial dimensions of the input.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n  N = nrow(X)\n  C = nrow(W)\n  Hout = as.integer(floor((Hin + 2*padh - Hf)/strideh + 1))\n  Wout = as.integer(floor((Win + 2*padw - Wf)/stridew + 1))\n\n  # create output volume\n  # NOTE: We initialize to 1s vs. 0s to avoid conversions between sparse and dense formats. \n  # This is a complete hack until the engine is improved.\n  out = matrix(1, rows=N, cols=C*M*Hout*Wout)\n\n  # depthwise convolution\n  # TODO: Explore usage of parfor loops more to determine if they can provide a performance\n  # benefit.  Initial tests show that they are slower than the regular for loop, likely because\n  # they cause a reduction from a multithreaded conv2d op to a singlethreaded version.  For a\n  # number of channels >> the number of examples, it's possible that the parfor loop could be\n  # faster.\n  #parfor (c in 1:C, check=0) {  # each channel\n  for (c in 1:C) {  # each channel\n    # run conv2d on each input channel separately, each with a different filter\n    Xc = X[,((c-1)*Hin*Win + 1):c*Hin*Win]  # shape (N, 1*Hin*Win)\n    Wc = matrix(W[c,], rows=M, cols=Hf*Wf)  # shape (M, Hf*Wf)\n    outc = conv2d(Xc, Wc, input_shape=[N,1,Hin,Win], filter_shape=[M,1,Hf,Wf],\n                  stride=[strideh,stridew], padding=[padh,padw])  # shape (N, M*Hout*Wout)\n    out[,((c-1)*M*Hout*Wout + 1):c*M*Hout*Wout] = outc\n  }\n\n  # add bias term to each output filter\n  out = bias_add(out, b)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) {
        String string = "source('scripts/nn/layers/conv2d_depthwise.dml') as mlcontextns;[dX, dW, db] = mlcontextns::backward(dout, Hout, Wout, X, W, b, Hin, Win, M, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("dout", object).in("Hout", object2).in("Wout", object3).in("X", object4).in("W", object5).in("b", object6).in("Hin", object7).in("Win", object8).in("M", object9).in("Hf", object10).in("Wf", object11).in("strideh", object12).in("stridew", object13).in("padh", object14).in("padw", object15).out("dX").out("dW").out("db");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int Hin, int Win, int M, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db) {\n  /*\n   * Computes the backward pass for a 2D depthwise spatial convolutional\n   * layer with C*M filters of depth 1.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C*M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, M*Hf*Wf).\n   *  - b: Biases, of shape (C*M, 1).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Num filters per input channel (i.e. depth multiplier).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (C, M*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (C*M, 1).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int Hin, int Win, int M, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db) {\n  /*\n   * Computes the backward pass for a 2D depthwise spatial convolutional\n   * layer with C*M filters of depth 1.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C*M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C, M*Hf*Wf).\n   *  - b: Biases, of shape (C*M, 1).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Num filters per input channel (i.e. depth multiplier).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (C, M*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (C*M, 1).\n   */\n  N = nrow(X)\n  C = nrow(W)\n\n  # create gradient volumes\n  # NOTE: We initialize to 1s vs. 0s to avoid conversions between sparse and dense formats. \n  # This is a complete hack until the engine is improved.\n  dX = matrix(1, rows=N, cols=C*Hin*Win)\n  dW = matrix(1, rows=C, cols=M*Hf*Wf)\n  db = matrix(1, rows=C*M, cols=1)\n\n  # partial derivatives for depthwise convolution\n  for (c in 1:C) {  # all examples\n    # extract channel c\n    doutc = dout[,((c-1)*M*Hout*Wout + 1):c*M*Hout*Wout]  # (N,M*Hout*Wout)\n    Xc = X[,((c-1)*Hin*Win + 1):c*Hin*Win]  # shape (N, 1*Hin*Win)\n    Wc = matrix(W[c,], rows=M, cols=Hf*Wf)  # shape (M, 1*Hf*Wf)\n\n    # compute gradients for channel c\n    dWc = conv2d_backward_filter(Xc, doutc, stride=[strideh,stridew], padding=[padh,padw],\n                                 input_shape=[N,1,Hin,Win], filter_shape=[M,1,Hf,Wf])\n    dXc = conv2d_backward_data(Wc, doutc, stride=[strideh,stridew], padding=[padh,padw],\n                               input_shape=[N,1,Hin,Win], filter_shape=[M,1,Hf,Wf])\n\n    # store\n    dX[,((c-1)*Hin*Win + 1):c*Hin*Win] = dXc\n    dW[c,] = matrix(dWc, rows=1, cols=M*Hf*Wf)\n  }\n\n  # partial derivatives for bias vector\n  db = util::channel_sums(dout, C*M, Hout, Wout)\n}\n";
        return string;
    }
}

