/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.scale_shift1d.Backward_output;
import org.apache.sysml.scripts.nn.layers.scale_shift1d.Init_output;

public class Scale_shift1d
extends Script {
    public Scale_shift1d() {
        String string = "scripts/nn/layers/scale_shift1d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object) {
        String string = "source('scripts/nn/layers/scale_shift1d.dml') as mlcontextns;[gamma, beta] = mlcontextns::init(D);";
        Script script = new Script(string);
        script.in("D", object).out("gamma").out("beta");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("gamma");
        Matrix matrix2 = mLResults.getMatrix("beta");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int D)\n    return (matrix[double] gamma, matrix[double] beta) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * By default, we initialize to an identity function, with a scale\n   * filler of `1`, and a shift filler of `0`.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - D: Dimensionality of the input features (number of features).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int D)\n    return (matrix[double] gamma, matrix[double] beta) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * By default, we initialize to an identity function, with a scale\n   * filler of `1`, and a shift filler of `0`.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - D: Dimensionality of the input features (number of features).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   */\n   gamma = matrix(1, rows=1, cols=D)\n   beta = matrix(0, rows=1, cols=D)\n}\n";
        return string;
    }

    public Matrix forward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/scale_shift1d.dml') as mlcontextns;out = mlcontextns::forward(X, gamma, beta);";
        Script script = new Script(string);
        script.in("X", object).in("gamma", object2).in("beta", object3).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a 1D scale & shift layer. The input\n   * data has N examples, each with D features.\n   *\n   * A 1D scale & shift layer introduces learnable parameters\n   * (gamma, beta) to scale and shift the input on a per-feature basis.\n   *\n   *   `y = x*gamma + beta`\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, D).\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a 1D scale & shift layer. The input\n   * data has N examples, each with D features.\n   *\n   * A 1D scale & shift layer introduces learnable parameters\n   * (gamma, beta) to scale and shift the input on a per-feature basis.\n   *\n   *   `y = x*gamma + beta`\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, D).\n   */\n  # Scale and shift\n  out = X*gamma + beta  # shape (N, D)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/nn/layers/scale_shift1d.dml') as mlcontextns;[dX, dgamma, dbeta] = mlcontextns::backward(dout, out, X, gamma, beta);";
        Script script = new Script(string);
        script.in("dout", object).in("out", object2).in("X", object3).in("gamma", object4).in("beta", object5).out("dX").out("dgamma").out("dbeta");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dgamma");
        Matrix matrix3 = mLResults.getMatrix("dbeta");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] out,\n                    matrix[double] X, matrix[double] gamma, matrix[double] beta)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 1D scale & shift layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, D).\n   *  - out: Outputs from the forward pass, of shape (N, D).\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, D).\n   *  - dgamma: Gradient wrt `W`, of shape (1, D).\n   *  - dbeta: Gradient wrt `b`, of shape (1, D).\n   *\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] out,\n                    matrix[double] X, matrix[double] gamma, matrix[double] beta)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 1D scale & shift layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, D).\n   *  - out: Outputs from the forward pass, of shape (N, D).\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, D).\n   *  - dgamma: Gradient wrt `W`, of shape (1, D).\n   *  - dbeta: Gradient wrt `b`, of shape (1, D).\n   *\n   */\n  # Compute gradients during training\n  dgamma = colSums(dout*X)  # shape (1, D)\n  dbeta = colSums(dout)  # shape (1, D)\n  dX = dout * gamma  # shape (N, D)\n}\n";
        return string;
    }
}

