/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Upsample2d
extends Script {
    public Upsample2d() {
        String string = "scripts/nn/layers/upsample2d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/layers/upsample2d.dml') as mlcontextns;out = mlcontextns::forward(X, C, Hin, Win, size_h, size_w);";
        Script script = new Script(string);
        script.in("X", object).in("C", object2).in("Hin", object3).in("Win", object4).in("size_h", object5).in("size_w", object6).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, int C, int Hin, int Win, int size_h, int size_w)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a Upsampling layer.\n   *\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - size_h: upsampling factor for rows.\n   *  - size_w: upsampling factor for columns.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hout*Wout), where Hout = Hin*size_h, and Wout = Win * size_w.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, int C, int Hin, int Win, int size_h, int size_w)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a Upsampling layer.\n   *\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - size_h: upsampling factor for rows.\n   *  - size_w: upsampling factor for columns.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hout*Wout), where Hout = Hin*size_h, and Wout = Win * size_w.\n   */\n  N = nrow(X)\n  Hout = size_h*Hin\n  Wout = size_w*Win\n  emptyInput = matrix(0, rows=N, cols=C*Hout*Wout)\n  out = avg_pool_backward(emptyInput, X, input_shape=[N,C,Hout,Wout], pool_size=[size_h,size_w], stride=[size_h,size_w], padding=[0,0])\n  out = out * size_h * size_w\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/layers/upsample2d.dml') as mlcontextns;dX = mlcontextns::backward(dout, C, Hin, Win, size_h, size_w);";
        Script script = new Script(string);
        script.in("dout", object).in("C", object2).in("Hin", object3).in("Win", object4).in("size_h", object5).in("size_w", object6).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int C, int Hin, int Win, int size_h, int size_w)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a Upsampling layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream.\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - size_h: upsampling factor for rows.\n   *  - size_w: upsampling factor for columns.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int C, int Hin, int Win, int size_h, int size_w)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a Upsampling layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream.\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - size_h: upsampling factor for rows.\n   *  - size_w: upsampling factor for columns.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n   N = nrow(dout)\n   Hout = size_h*Hin\n   Wout = size_w*Win\n   dX = avg_pool(dout, input_shape=[N,C,Hout,Wout], pool_size=[size_h,size_w], stride=[size_h,size_w], padding=[0,0])\n   dX = dX * size_h * size_w\n}\n";
        return string;
    }
}

