/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.metrics;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.yarn.api.records.Resource;

@Metrics(about="Metrics for node manager", context="yarn")
public class NodeManagerMetrics {
    @Metric
    MutableCounterInt containersLaunched;
    @Metric
    MutableCounterInt containersCompleted;
    @Metric
    MutableCounterInt containersFailed;
    @Metric
    MutableCounterInt containersKilled;
    @Metric(value={"# of initializing containers"})
    MutableGaugeInt containersIniting;
    @Metric
    MutableGaugeInt containersRunning;
    @Metric(value={"Current allocated memory in GB"})
    MutableGaugeInt allocatedGB;
    @Metric(value={"Current # of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric
    MutableGaugeInt availableGB;
    @Metric(value={"Current allocated Virtual Cores"})
    MutableGaugeInt allocatedVCores;
    @Metric
    MutableGaugeInt availableVCores;

    public static NodeManagerMetrics create() {
        return NodeManagerMetrics.create(DefaultMetricsSystem.instance());
    }

    static NodeManagerMetrics create(MetricsSystem ms) {
        JvmMetrics.create((String)"NodeManager", null, (MetricsSystem)ms);
        return (NodeManagerMetrics)ms.register((Object)new NodeManagerMetrics());
    }

    public void launchedContainer() {
        this.containersLaunched.incr();
    }

    public void completedContainer() {
        this.containersCompleted.incr();
    }

    public void failedContainer() {
        this.containersFailed.incr();
    }

    public void killedContainer() {
        this.containersKilled.incr();
    }

    public void initingContainer() {
        this.containersIniting.incr();
    }

    public void endInitingContainer() {
        this.containersIniting.decr();
    }

    public void runningContainer() {
        this.containersRunning.incr();
    }

    public void endRunningContainer() {
        this.containersRunning.decr();
    }

    public void allocateContainer(Resource res) {
        this.allocatedContainers.incr();
        this.allocatedGB.incr(res.getMemory() / 1024);
        this.availableGB.decr(res.getMemory() / 1024);
        this.allocatedVCores.incr(res.getVirtualCores());
        this.availableVCores.decr(res.getVirtualCores());
    }

    public void releaseContainer(Resource res) {
        this.allocatedContainers.decr();
        this.allocatedGB.decr(res.getMemory() / 1024);
        this.availableGB.incr(res.getMemory() / 1024);
        this.allocatedVCores.decr(res.getVirtualCores());
        this.availableVCores.incr(res.getVirtualCores());
    }

    public void addResource(Resource res) {
        this.availableGB.incr(res.getMemory() / 1024);
        this.availableVCores.incr(res.getVirtualCores());
    }

    public int getRunningContainers() {
        return this.containersRunning.value();
    }
}

