/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandler;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;

public class FederatedData {
    protected static final Logger log = Logger.getLogger(FederatedWorkerHandler.class);
    private static final Set<InetSocketAddress> _allFedSites = new HashSet<InetSocketAddress>();
    private final Types.DataType _dataType;
    private final InetSocketAddress _address;
    private final String _filepath;
    private long _varID = -1L;

    public FederatedData(Types.DataType dataType, InetSocketAddress address, String filepath) {
        this._dataType = dataType;
        this._address = address;
        this._filepath = filepath;
        if (this._address != null) {
            _allFedSites.add(this._address);
        }
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setVarID(long varID) {
        this._varID = varID;
    }

    public long getVarID() {
        return this._varID;
    }

    public String getFilepath() {
        return this._filepath;
    }

    public boolean isInitialized() {
        return this._varID != -1L;
    }

    boolean equalAddress(FederatedData that) {
        return this._address != null && that != null && that._address != null && this._address.equals(that._address);
    }

    public FederatedData copyWithNewID(long varID) {
        FederatedData copy = new FederatedData(this._dataType, this._address, this._filepath);
        copy.setVarID(varID);
        return copy;
    }

    public synchronized Future<FederatedResponse> initFederatedData(long id) {
        if (this.isInitialized()) {
            throw new DMLRuntimeException("Tried to init already initialized data");
        }
        if (!this._dataType.isMatrix() && !this._dataType.isFrame()) {
            throw new DMLRuntimeException("Federated datatype \"" + this._dataType.toString() + "\" is not supported.");
        }
        this._varID = id;
        FederatedRequest request = new FederatedRequest(FederatedRequest.RequestType.READ_VAR, id);
        request.appendParam(this._filepath);
        request.appendParam(this._dataType.name());
        return this.executeFederatedOperation(request);
    }

    public synchronized Future<FederatedResponse> executeFederatedOperation(FederatedRequest ... request) {
        return FederatedData.executeFederatedOperation(this._address, request);
    }

    public static Future<FederatedResponse> executeFederatedOperation(InetSocketAddress address, FederatedRequest ... request) {
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(2);
        try {
            Bootstrap b = new Bootstrap();
            final DataRequestHandler handler = new DataRequestHandler((EventLoopGroup)workerGroup);
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast("ObjectDecoder", (ChannelHandler)new ObjectDecoder(Integer.MAX_VALUE, ClassResolvers.weakCachingResolver((ClassLoader)ClassLoader.getSystemClassLoader()))).addLast("FederatedOperationHandler", (ChannelHandler)handler).addLast("ObjectEncoder", (ChannelHandler)new ObjectEncoder());
                }
            });
            ChannelFuture f = b.connect((SocketAddress)address).sync();
            Promise promise = f.channel().eventLoop().newPromise();
            handler.setPromise((Promise<FederatedResponse>)promise);
            f.channel().writeAndFlush((Object)request);
            return promise;
        }
        catch (InterruptedException e) {
            throw new DMLRuntimeException("Could not send federated operation.");
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFederatedWorkers() {
        if (_allFedSites.isEmpty()) {
            return;
        }
        try {
            FederatedRequest fr = new FederatedRequest(FederatedRequest.RequestType.CLEAR);
            ArrayList<Future<FederatedResponse>> ret = new ArrayList<Future<FederatedResponse>>();
            for (InetSocketAddress address : _allFedSites) {
                ret.add(FederatedData.executeFederatedOperation(address, fr));
            }
            FederationUtils.waitFor(ret);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to execute CLEAR request on existing federated sites.", (Throwable)ex);
        }
        finally {
            FederatedData.resetFederatedSites();
        }
    }

    public static void resetFederatedSites() {
        _allFedSites.clear();
    }

    private static class DataRequestHandler
    extends ChannelInboundHandlerAdapter {
        private Promise<FederatedResponse> _prom;
        private EventLoopGroup _workerGroup;

        public DataRequestHandler(EventLoopGroup workerGroup) {
            this._workerGroup = workerGroup;
        }

        public void setPromise(Promise<FederatedResponse> prom) {
            this._prom = prom;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (this._prom == null) {
                throw new DMLRuntimeException("Read while no message was sent");
            }
            this._prom.setSuccess((Object)((FederatedResponse)msg));
            ctx.close();
            this._workerGroup.shutdownGracefully();
        }
    }
}

