/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderBin
extends Encoder {
    private static final long serialVersionUID = 1917445005206076078L;
    public static final String MIN_PREFIX = "min";
    public static final String MAX_PREFIX = "max";
    public static final String NBINS_PREFIX = "nbins";
    protected int[] _numBins = null;
    private double[][] _binMins = null;
    private double[][] _binMaxs = null;

    public EncoderBin(JSONObject parsedSpec, String[] colnames, int clen, int minCol, int maxCol) throws JSONException, IOException {
        super(null, clen);
        if (!parsedSpec.containsKey(TfUtils.TfMethod.BIN.toString())) {
            return;
        }
        List<Integer> collist = TfMetaUtils.parseBinningColIDs(parsedSpec, colnames, minCol, maxCol);
        this.initColList(ArrayUtils.toPrimitive((Integer[])collist.toArray(new Integer[0])));
        boolean ids = parsedSpec.containsKey("ids") && parsedSpec.getBoolean("ids");
        JSONArray group = (JSONArray)parsedSpec.get(TfUtils.TfMethod.BIN.toString());
        this._numBins = new int[collist.size()];
        for (Object o : group) {
            JSONObject colspec = (JSONObject)o;
            int ixOffset = minCol == -1 ? 0 : minCol - 1;
            int pos = collist.indexOf(ids ? colspec.getInt("id") - ixOffset : ArrayUtils.indexOf((Object[])colnames, (Object)colspec.get("name")) + 1);
            if (pos < 0) continue;
            this._numBins[pos] = colspec.containsKey("numbins") ? colspec.getInt("numbins") : 1;
        }
    }

    public EncoderBin() {
        super(new int[0], 0);
        this._numBins = new int[0];
    }

    private EncoderBin(int[] colList, int clen, int[] numBins, double[][] binMins, double[][] binMaxs) {
        super(colList, clen);
        this._numBins = numBins;
        this._binMins = binMins;
        this._binMaxs = binMaxs;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        this.build(in);
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int j = 0; j < this._colList.length; ++j) {
            int i;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int colID = this._colList[j];
            for (i = 0; i < in.getNumRows(); ++i) {
                double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                min = Math.min(min, inVal);
                max = Math.max(max, inVal);
            }
            this._binMins[j] = new double[this._numBins[j]];
            this._binMaxs[j] = new double[this._numBins[j]];
            for (i = 0; i < this._numBins[j]; ++i) {
                this._binMins[j][i] = min + (double)i * (max - min) / (double)this._numBins[j];
                this._binMaxs[j][i] = min + (double)(i + 1) * (max - min) / (double)this._numBins[j];
            }
        }
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                int ix = Arrays.binarySearch(this._binMaxs[j], inVal);
                int binID = (ix < 0 ? Math.abs(ix + 1) : ix) + 1;
                out.quickSetValue(i, colID - 1, binID);
            }
        }
        return out;
    }

    @Override
    public Encoder subRangeEncoder(IndexRange ixRange) {
        ArrayList<Integer> colsList = new ArrayList<Integer>();
        ArrayList<Integer> numBinsList = new ArrayList<Integer>();
        ArrayList<double[]> binMinsList = new ArrayList<double[]>();
        ArrayList<double[]> binMaxsList = new ArrayList<double[]>();
        for (int i2 = 0; i2 < this._colList.length; ++i2) {
            int col = this._colList[i2];
            if ((long)col < ixRange.colStart || (long)col >= ixRange.colEnd) continue;
            int corrColumn = (int)((long)col - (ixRange.colStart - 1L));
            colsList.add(corrColumn);
            numBinsList.add(this._numBins[i2]);
            binMinsList.add(this._binMins[i2]);
            binMaxsList.add(this._binMaxs[i2]);
        }
        if (colsList.isEmpty()) {
            return null;
        }
        int[] colList = colsList.stream().mapToInt(i -> i).toArray();
        return new EncoderBin(colList, (int)(ixRange.colEnd - ixRange.colStart), numBinsList.stream().mapToInt(i -> i).toArray(), (double[][])binMinsList.toArray((T[])new double[0][0]), (double[][])binMaxsList.toArray((T[])new double[0][0]));
    }

    @Override
    public void mergeAt(Encoder other, int row, int col) {
        if (other instanceof EncoderBin) {
            MutableTriple entry;
            int column;
            int i;
            EncoderBin otherBin = (EncoderBin)other;
            HashMap<Integer, MutableTriple> ixBinsMap = new HashMap<Integer, MutableTriple>();
            for (i = 0; i < this._colList.length; ++i) {
                ixBinsMap.put(this._colList[i], new MutableTriple((Object)this._numBins[i], (Object)this._binMins[i][0], (Object)this._binMaxs[i][this._binMaxs[i].length - 1]));
            }
            for (i = 0; i < otherBin._colList.length; ++i) {
                column = otherBin._colList[i] + (col - 1);
                entry = (MutableTriple)ixBinsMap.get(column);
                if (entry == null) {
                    ixBinsMap.put(column, new MutableTriple((Object)otherBin._numBins[i], (Object)otherBin._binMins[i][0], (Object)otherBin._binMaxs[i][otherBin._binMaxs[i].length - 1]));
                    continue;
                }
                entry.middle = Math.min((Double)entry.middle, otherBin._binMins[i][0]);
                entry.right = Math.max((Double)entry.right, otherBin._binMaxs[i][otherBin._binMaxs[i].length - 1]);
            }
            this.mergeColumnInfo(other, col);
            this._numBins = new int[this._colList.length];
            this._binMins = new double[this._colList.length][];
            this._binMaxs = new double[this._colList.length][];
            for (i = 0; i < this._colList.length; ++i) {
                column = this._colList[i];
                entry = (MutableTriple)ixBinsMap.get(column);
                this._numBins[i] = (Integer)entry.left;
                double min = (Double)entry.middle;
                double max = (Double)entry.right;
                this._binMins[i] = new double[this._numBins[i]];
                this._binMaxs[i] = new double[this._numBins[i]];
                for (int j = 0; j < this._numBins[i]; ++j) {
                    this._binMins[i][j] = min + (double)j * (max - min) / (double)this._numBins[i];
                    this._binMaxs[i][j] = min + (double)(j + 1) * (max - min) / (double)this._numBins[i];
                }
            }
            return;
        }
        super.mergeAt(other, row, col);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        int j;
        int maxLength = 0;
        for (j = 0; j < this._colList.length; ++j) {
            maxLength = Math.max(maxLength, this._binMaxs[j].length);
        }
        meta.ensureAllocatedColumns(maxLength);
        for (j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            meta.getColumnMetadata(colID - 1).setNumDistinct(this._numBins[j]);
            for (int i = 0; i < this._binMaxs[j].length; ++i) {
                StringBuilder sb = new StringBuilder(16);
                sb.append(this._binMins[j][i]);
                sb.append("\u00b7");
                sb.append(this._binMaxs[j][i]);
                meta.set(i, colID - 1, sb.toString());
            }
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || this._binMaxs != null) {
            return;
        }
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int nbins = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._binMins[j] = new double[nbins];
            this._binMaxs[j] = new double[nbins];
            for (int i = 0; i < nbins; ++i) {
                String[] tmp = meta.get(i, colID - 1).toString().split("\u00b7");
                this._binMins[j][i] = Double.parseDouble(tmp[0]);
                this._binMaxs[j][i] = Double.parseDouble(tmp[1]);
            }
        }
    }
}

