/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.MatrixBuiltinGPUInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class BuiltinUnaryGPUInstruction
extends GPUInstruction {
    int _arity;
    CPOperand _input;
    CPOperand _output;

    protected BuiltinUnaryGPUInstruction(Operator op, CPOperand in, CPOperand out, int _arity, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary;
        this._arity = _arity;
        this._input = in;
        this._output = out;
    }

    public int getArity() {
        return this._arity;
    }

    public static BuiltinUnaryGPUInstruction parseInstruction(String str) {
        CPOperand in = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = null;
        if (parts.length == 4) {
            throw new DMLRuntimeException("The instruction is not supported on GPU:" + str);
        }
        InstructionUtils.checkNumFields(str, 2);
        opcode = parts[0];
        in.split(parts[1]);
        out.split(parts[2]);
        if (in.getDataType() == Types.DataType.SCALAR) {
            throw new DMLRuntimeException("The instruction is not supported on GPU:" + str);
        }
        if (in.getDataType() == Types.DataType.MATRIX) {
            return new MatrixBuiltinGPUInstruction(null, in, out, opcode, str);
        }
        return null;
    }
}

