/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Foo;
import org.apache.avro.Interop;
import org.apache.avro.Kind;
import org.apache.avro.MD5;
import org.apache.avro.Node;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.junit.Assert;
import org.junit.Test;

public class TestDeepCopy {
    @Test
    public void testDeepCopy() {
        Interop.Builder interopBuilder = Interop.newBuilder();
        interopBuilder.setArrayField(Arrays.asList(1.1, 1.2, 1.3, 1.4));
        interopBuilder.setBoolField(true);
        interopBuilder.setBytesField(ByteBuffer.wrap(new byte[]{1, 2, 3, 4}));
        interopBuilder.setDoubleField(3.14);
        interopBuilder.setEnumField(Kind.B);
        interopBuilder.setFixedField(new MD5(new byte[]{4, 3, 2, 1, 4, 3, 2, 1, 4, 3, 2, 1, 4, 3, 2, 1}));
        interopBuilder.setFloatField(6.022f);
        interopBuilder.setIntField(32);
        interopBuilder.setLongField(64L);
        HashMap<String, Foo> map = new HashMap<String, Foo>(1);
        map.put("foo", Foo.newBuilder().setLabel("bar").build());
        interopBuilder.setMapField(map);
        interopBuilder.setNullField(null);
        Node.Builder rootBuilder = Node.newBuilder().setLabel("/");
        Node.Builder homeBuilder = Node.newBuilder().setLabel("home");
        homeBuilder.setChildren(new ArrayList<Node>(0));
        rootBuilder.setChildren(Arrays.asList(homeBuilder.build()));
        interopBuilder.setRecordField(rootBuilder.build());
        interopBuilder.setStringField("Hello");
        interopBuilder.setUnionField(Arrays.asList(ByteBuffer.wrap(new byte[]{1, 2})));
        Interop interop = interopBuilder.build();
        for (Schema.Field field : Interop.SCHEMA$.getFields()) {
            if (interop.get(field.pos()) instanceof ByteBuffer) {
                Assert.assertTrue((boolean)Arrays.equals(((ByteBuffer)interop.get(field.pos())).array(), ((ByteBuffer)GenericData.get().deepCopy(field.schema(), interop.get(field.pos()))).array()));
            } else {
                Assert.assertEquals((Object)interop.get(field.pos()), (Object)SpecificData.get().deepCopy(field.schema(), interop.get(field.pos())));
            }
            if (field.schema().getType() == Schema.Type.ENUM || field.schema().getType() == Schema.Type.NULL || field.schema().getType() == Schema.Type.BOOLEAN || field.schema().getType() == Schema.Type.INT || field.schema().getType() == Schema.Type.LONG || field.schema().getType() == Schema.Type.FLOAT || field.schema().getType() == Schema.Type.DOUBLE || field.schema().getType() == Schema.Type.STRING) continue;
            Assert.assertFalse((String)("Field " + field.name() + " is same instance in deep copy"), (interop.get(field.pos()) == GenericData.get().deepCopy(field.schema(), interop.get(field.pos())) ? 1 : 0) != 0);
        }
    }
}

