/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.InsertionSorterFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorExact;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.lib.BitmapEncoder;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public final class ColGroupFactory {
    private static final Log LOG = LogFactory.getLog((String)ColGroupFactory.class.getName());

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings compSettings, int k) {
        if (k <= 1) {
            return ColGroupFactory.compressColGroupsSingleThreaded(in, csi, compSettings);
        }
        return ColGroupFactory.compressColGroupsParallel(in, csi, compSettings, k);
    }

    private static List<AColGroup> compressColGroupsSingleThreaded(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings compSettings) {
        ArrayList<AColGroup> ret = new ArrayList<AColGroup>(csi.getNumberColGroups());
        for (CompressedSizeInfoColGroup g : csi.getInfo()) {
            ret.addAll(ColGroupFactory.compressColGroup(in, g.getColumns(), compSettings));
        }
        return ret;
    }

    private static List<AColGroup> compressColGroupsParallel(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings compSettings, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<CompressTask> tasks = new ArrayList<CompressTask>();
            for (CompressedSizeInfoColGroup g : csi.getInfo()) {
                tasks.add(new CompressTask(in, g.getColumns(), compSettings));
            }
            ArrayList<AColGroup> ret = new ArrayList<AColGroup>(csi.getNumberColGroups());
            for (Future t : pool.invokeAll(tasks)) {
                ret.addAll((Collection)t.get());
            }
            pool.shutdown();
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DMLRuntimeException("Failed compression ", e);
        }
    }

    private static Collection<AColGroup> compressColGroup(MatrixBlock in, int[] colIndexes, CompressionSettings compSettings) {
        if (in.isEmpty()) {
            return Collections.singletonList(new ColGroupEmpty(colIndexes, compSettings.transposed ? in.getNumColumns() : in.getNumRows()));
        }
        if (in.isInSparseFormat() && compSettings.transposed) {
            SparseBlock sb = in.getSparseBlock();
            for (int col : colIndexes) {
                if (!sb.isEmpty(col)) continue;
                return ColGroupFactory.compressColGroupAndExtractEmptyColumns(in, colIndexes, compSettings);
            }
            return Collections.singletonList(ColGroupFactory.compressColGroupForced(in, colIndexes, compSettings));
        }
        return Collections.singletonList(ColGroupFactory.compressColGroupForced(in, colIndexes, compSettings));
    }

    private static Collection<AColGroup> compressColGroupAndExtractEmptyColumns(MatrixBlock in, int[] colIndexes, CompressionSettings compSettings) {
        IntArrayList e = new IntArrayList();
        IntArrayList v = new IntArrayList();
        SparseBlock sb = in.getSparseBlock();
        for (int col : colIndexes) {
            if (sb.isEmpty(col)) {
                e.appendValue(col);
                continue;
            }
            v.appendValue(col);
        }
        AColGroup empty = ColGroupFactory.compressColGroupForced(in, e.extractValues(true), compSettings);
        if (v.size() > 0) {
            AColGroup colGroup = ColGroupFactory.compressColGroupForced(in, v.extractValues(true), compSettings);
            return Arrays.asList(empty, colGroup);
        }
        return Collections.singletonList(empty);
    }

    private static AColGroup compressColGroupForced(MatrixBlock in, int[] colIndexes, CompressionSettings compSettings) {
        ABitmap ubm = BitmapEncoder.extractBitmap(colIndexes, in, compSettings.transposed);
        CompressedSizeEstimatorExact estimator = new CompressedSizeEstimatorExact(in, compSettings);
        CompressedSizeInfoColGroup sizeInfo = new CompressedSizeInfoColGroup(estimator.estimateCompressedColGroupSize(ubm, colIndexes), compSettings.validCompressions, ubm);
        int numRows = compSettings.transposed ? in.getNumColumns() : in.getNumRows();
        return ColGroupFactory.compress(colIndexes, numRows, ubm, sizeInfo.getBestCompressionType(compSettings), compSettings, in, sizeInfo.getTupleSparsity());
    }

    public static AColGroup compress(int[] colIndexes, int rlen, ABitmap ubm, AColGroup.CompressionType compType, CompressionSettings cs, MatrixBlock rawMatrixBlock, double tupleSparsity) {
        IntArrayList[] of = ubm.getOffsetList();
        if (of == null) {
            return new ColGroupEmpty(colIndexes, rlen);
        }
        if (of.length == 1 && of[0].size() == rlen) {
            return new ColGroupConst(colIndexes, rlen, DictionaryFactory.create(ubm));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("compressing to: " + (Object)((Object)compType)));
        }
        try {
            if (cs.sortValuesByLength) {
                ubm.sortValuesByFrequency();
            }
            switch (compType) {
                case DDC: {
                    return ColGroupFactory.compressDDC(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case RLE: {
                    return ColGroupFactory.compressRLE(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case OLE: {
                    return ColGroupFactory.compressOLE(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case SDC: {
                    return ColGroupFactory.compressSDC(colIndexes, rlen, ubm, cs, tupleSparsity);
                }
                case UNCOMPRESSED: {
                    return new ColGroupUncompressed(colIndexes, rawMatrixBlock, cs.transposed);
                }
            }
            throw new DMLCompressionException("Not implemented ColGroup Type compressed in factory.");
        }
        catch (DMLCompressionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLCompressionException("Error in construction of colGroup type: " + (Object)((Object)compType), e);
        }
    }

    private static AColGroup compressSDC(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        AColGroup cg;
        int numZeros = (int)((long)rlen - (long)((int)ubm.getNumOffsets()));
        int largestOffset = 0;
        int largestIndex = 0;
        int index = 0;
        for (IntArrayList a : ubm.getOffsetList()) {
            if (a.size() > largestOffset) {
                largestOffset = a.size();
                largestIndex = index;
            }
            ++index;
        }
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        if (numZeros >= largestOffset && ubm.getOffsetList().length == 1) {
            cg = new ColGroupSDCSingleZeros(colIndexes, rlen, dict, ubm.getOffsetList()[0].extractValues(true), null);
        } else if (ubm.getOffsetList().length == 1) {
            dict = DictionaryFactory.moveFrequentToLastDictionaryEntry(dict, ubm, rlen, largestIndex);
            cg = ColGroupFactory.setupSingleValueSDCColGroup(colIndexes, rlen, ubm, dict);
        } else if (numZeros >= largestOffset) {
            cg = ColGroupFactory.setupMultiValueZeroColGroup(colIndexes, ubm, rlen, dict);
        } else {
            dict = DictionaryFactory.moveFrequentToLastDictionaryEntry(dict, ubm, rlen, largestIndex);
            cg = ColGroupFactory.setupMultiValueColGroup(colIndexes, numZeros, largestOffset, ubm, rlen, largestIndex, dict);
        }
        return cg;
    }

    private static AColGroup setupMultiValueZeroColGroup(int[] colIndexes, ABitmap ubm, int numRows, ADictionary dict) {
        IntArrayList[] offsets = ubm.getOffsetList();
        try {
            int numOffsets = (int)ubm.getNumOffsets();
            AInsertionSorter s = InsertionSorterFactory.create(numOffsets, numRows, offsets);
            int[] _indexes = s.getIndexes();
            AMapToData _data = s.getData();
            return new ColGroupSDCZeros(colIndexes, numRows, dict, _indexes, _data, null);
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed to construct SDC Zero Group with columns :" + Arrays.toString(colIndexes), e);
        }
    }

    private static AColGroup setupMultiValueColGroup(int[] colIndexes, int numZeros, int largestOffset, ABitmap ubm, int numRows, int largestIndex, ADictionary dict) {
        try {
            IntArrayList[] offsets = ubm.getOffsetList();
            AInsertionSorter s = InsertionSorterFactory.create(numRows - largestOffset, numRows, offsets, largestIndex);
            int[] _indexes = s.getIndexes();
            AMapToData _data = s.getData();
            ColGroupSDC ret = new ColGroupSDC(colIndexes, numRows, dict, _indexes, _data, null);
            return ret;
        }
        catch (Exception e) {
            throw new DMLCompressionException("Failed to construct SDC Group with columns :" + Arrays.toString(colIndexes), e);
        }
    }

    private static AColGroup setupSingleValueSDCColGroup(int[] colIndexes, int numRows, ABitmap ubm, ADictionary dict) {
        IntArrayList inv = ubm.getOffsetsList(0);
        int[] _indexes = new int[numRows - inv.size()];
        int p = 0;
        int v = 0;
        for (int i = 0; i < inv.size(); ++i) {
            int j = inv.get(i);
            while (v < j) {
                _indexes[p++] = v++;
            }
            if (v != j) continue;
            ++v;
        }
        while (v < numRows) {
            _indexes[p++] = v++;
        }
        return new ColGroupSDCSingle(colIndexes, numRows, dict, _indexes, null);
    }

    private static AColGroup compressDDC(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        boolean zeros = ubm.getNumOffsets() < (long)rlen;
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity, zeros);
        AMapToData data = MapToFactory.create(rlen, zeros, ubm.getOffsetList());
        return new ColGroupDDC(colIndexes, rlen, dict, data, null);
    }

    private static AColGroup compressOLE(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        ColGroupOLE ole = new ColGroupOLE(rlen);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int i = 0; i < numVals; ++i) {
            lbitmaps[i] = ColGroupOLE.genOffsetBitmap(ubm.getOffsetsList(i).extractValues(), ubm.getNumOffsets(i));
            totalLen += lbitmaps[i].length;
        }
        ole.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        ole._dict = dict;
        ole._zeros = ubm.getNumOffsets() < (long)rlen;
        ole._colIndexes = colIndexes;
        return ole;
    }

    private static AColGroup compressRLE(int[] colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        ADictionary dict = DictionaryFactory.create(ubm, tupleSparsity);
        ColGroupRLE rle = new ColGroupRLE(rlen);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int k = 0; k < numVals; ++k) {
            lbitmaps[k] = ColGroupRLE.genRLEBitmap(ubm.getOffsetsList(k).extractValues(), ubm.getNumOffsets(k));
            totalLen += lbitmaps[k].length;
        }
        rle.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        rle._dict = dict;
        rle._zeros = ubm.getNumOffsets() < (long)rlen;
        rle._colIndexes = colIndexes;
        return rle;
    }

    public static AColGroup genColGroupConst(int numRows, int numCols, double value) {
        int[] colIndices = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colIndices[i] = i;
        }
        if (value == 0.0) {
            return new ColGroupEmpty(colIndices, numRows);
        }
        return ColGroupFactory.getColGroupConst(numRows, colIndices, value);
    }

    public static AColGroup getColGroupConst(int numRows, int[] cols, double value) {
        int numCols = cols.length;
        double[] values = new double[numCols];
        for (int i = 0; i < numCols; ++i) {
            values[i] = value;
        }
        Dictionary dict = new Dictionary(values);
        return new ColGroupConst(cols, numRows, dict);
    }

    private static class CompressTask
    implements Callable<Collection<AColGroup>> {
        private final MatrixBlock _in;
        private final int[] _colIndexes;
        private final CompressionSettings _compSettings;

        protected CompressTask(MatrixBlock in, int[] colIndexes, CompressionSettings compSettings) {
            this._in = in;
            this._colIndexes = colIndexes;
            this._compSettings = compSettings;
        }

        @Override
        public Collection<AColGroup> call() {
            return ColGroupFactory.compressColGroup(this._in, this._colIndexes, this._compSettings);
        }
    }
}

