/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import java.util.HashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.AggregateTernarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendGAlignedSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendGSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendMSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendRSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinUaggChainSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.BuiltinNarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.CSVReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CastSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CentralMomentSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CheckpointSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CompressionSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CovarianceSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CpmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CtableSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CumulativeAggregateSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CumulativeOffsetSPInstruction;
import org.apache.sysds.runtime.instructions.spark.DnnSPInstruction;
import org.apache.sysds.runtime.instructions.spark.IndexingSPInstruction;
import org.apache.sysds.runtime.instructions.spark.LIBSVMReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmChainSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MatrixReshapeSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MultiReturnParameterizedBuiltinSPInstruction;
import org.apache.sysds.runtime.instructions.spark.PMapmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ParameterizedBuiltinSPInstruction;
import org.apache.sysds.runtime.instructions.spark.PmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantilePickSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantileSortSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuaternarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.RandSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ReorgSPInstruction;
import org.apache.sysds.runtime.instructions.spark.RmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.SpoofSPInstruction;
import org.apache.sysds.runtime.instructions.spark.TernarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.Tsmm2SPInstruction;
import org.apache.sysds.runtime.instructions.spark.TsmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UaggOuterChainSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnaryFrameSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnaryMatrixSPInstruction;
import org.apache.sysds.runtime.instructions.spark.WriteSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ZipmmSPInstruction;

public class SPInstructionParser
extends InstructionParser {
    public static final HashMap<String, SPInstruction.SPType> String2SPInstructionType = new HashMap();

    public static SPInstruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        SPInstruction.SPType cptype = InstructionUtils.getSPType(str);
        if (cptype == null) {
            throw new DMLRuntimeException("Invalid SP Instruction Type: " + str);
        }
        SPInstruction spinst = SPInstructionParser.parseSingleInstruction(cptype, str);
        if (spinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return spinst;
    }

    public static SPInstruction parseSingleInstruction(SPInstruction.SPType sptype, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] parts = null;
        switch (sptype) {
            case CPMM: {
                return CpmmSPInstruction.parseInstruction(str);
            }
            case RMM: {
                return RmmSPInstruction.parseInstruction(str);
            }
            case MAPMM: {
                return MapmmSPInstruction.parseInstruction(str);
            }
            case MAPMMCHAIN: {
                return MapmmChainSPInstruction.parseInstruction(str);
            }
            case TSMM: {
                return TsmmSPInstruction.parseInstruction(str);
            }
            case TSMM2: {
                return Tsmm2SPInstruction.parseInstruction(str);
            }
            case PMM: {
                return PmmSPInstruction.parseInstruction(str);
            }
            case ZIPMM: {
                return ZipmmSPInstruction.parseInstruction(str);
            }
            case PMAPMM: {
                return PMapmmSPInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainSPInstruction.parseInstruction(str);
            }
            case AggregateUnary: {
                return AggregateUnarySPInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernarySPInstruction.parseInstruction(str);
            }
            case Dnn: {
                return DnnSPInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                return IndexingSPInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgSPInstruction.parseInstruction(str);
            }
            case Binary: {
                return BinarySPInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernarySPInstruction.parseInstruction(str);
            }
            case Ctable: {
                return CtableSPInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternarySPInstruction.parseInstruction(str);
            }
            case Reblock: {
                return ReblockSPInstruction.parseInstruction(str);
            }
            case CSVReblock: {
                return CSVReblockSPInstruction.parseInstruction(str);
            }
            case LIBSVMReblock: {
                return LIBSVMReblockSPInstruction.parseInstruction(str);
            }
            case Builtin: {
                parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts[0].equals("log") || parts[0].equals("log_nz")) {
                    if (parts.length == 3) {
                        return UnaryMatrixSPInstruction.parseInstruction(str);
                    }
                    if (parts.length == 4) {
                        return BinarySPInstruction.parseInstruction(str);
                    }
                } else {
                    throw new DMLRuntimeException("Invalid Builtin Instruction: " + str);
                }
            }
            case Unary: {
                parts = InstructionUtils.getInstructionPartsWithValueType(str);
                CPOperand in = new CPOperand(parts[1]);
                if (in.getDataType() == Types.DataType.MATRIX) {
                    return UnaryMatrixSPInstruction.parseInstruction(str);
                }
                return UnaryFrameSPInstruction.parseInstruction(str);
            }
            case BuiltinNary: {
                return BuiltinNarySPInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                return ParameterizedBuiltinSPInstruction.parseInstruction(str);
            }
            case MultiReturnBuiltin: {
                return MultiReturnParameterizedBuiltinSPInstruction.parseInstruction(str);
            }
            case MatrixReshape: {
                return MatrixReshapeSPInstruction.parseInstruction(str);
            }
            case MAppend: {
                return AppendMSPInstruction.parseInstruction(str);
            }
            case RAppend: {
                return AppendRSPInstruction.parseInstruction(str);
            }
            case GAppend: {
                return AppendGSPInstruction.parseInstruction(str);
            }
            case GAlignedAppend: {
                return AppendGAlignedSPInstruction.parseInstruction(str);
            }
            case Rand: {
                return RandSPInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortSPInstruction.parseInstruction(str);
            }
            case QPick: {
                return QuantilePickSPInstruction.parseInstruction(str);
            }
            case Write: {
                return WriteSPInstruction.parseInstruction(str);
            }
            case CumsumAggregate: {
                return CumulativeAggregateSPInstruction.parseInstruction(str);
            }
            case CumsumOffset: {
                return CumulativeOffsetSPInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentSPInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceSPInstruction.parseInstruction(str);
            }
            case BinUaggChain: {
                return BinUaggChainSPInstruction.parseInstruction(str);
            }
            case Checkpoint: {
                return CheckpointSPInstruction.parseInstruction(str);
            }
            case Compression: {
                return CompressionSPInstruction.parseInstruction(str);
            }
            case SpoofFused: {
                return SpoofSPInstruction.parseInstruction(str);
            }
            case Cast: {
                return CastSPInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid SP Instruction Type: " + (Object)((Object)sptype));
    }

    static {
        String2SPInstructionType.put("uak+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uark+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uack+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uasqk+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarsqk+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uacsqk+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uamean", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarmean", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uacmean", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uavar", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarvar", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uacvar", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uamax", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarmax", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarimax", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uacmax", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uamin", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarmin", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uarimin", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uacmin", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("ua+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uar+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uac+", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("ua*", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uar*", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uac*", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uatrace", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("uaktrace", SPInstruction.SPType.AggregateUnary);
        String2SPInstructionType.put("mapmm", SPInstruction.SPType.MAPMM);
        String2SPInstructionType.put("mapmmchain", SPInstruction.SPType.MAPMMCHAIN);
        String2SPInstructionType.put("tsmm", SPInstruction.SPType.TSMM);
        String2SPInstructionType.put("tsmm2", SPInstruction.SPType.TSMM2);
        String2SPInstructionType.put("cpmm", SPInstruction.SPType.CPMM);
        String2SPInstructionType.put("rmm", SPInstruction.SPType.RMM);
        String2SPInstructionType.put("pmm", SPInstruction.SPType.PMM);
        String2SPInstructionType.put("zipmm", SPInstruction.SPType.ZIPMM);
        String2SPInstructionType.put("pmapmm", SPInstruction.SPType.PMAPMM);
        String2SPInstructionType.put("uaggouterchain", SPInstruction.SPType.UaggOuterChain);
        String2SPInstructionType.put("tak+*", SPInstruction.SPType.AggregateTernary);
        String2SPInstructionType.put("tack+*", SPInstruction.SPType.AggregateTernary);
        String2SPInstructionType.put("conv2d", SPInstruction.SPType.Dnn);
        String2SPInstructionType.put("conv2d_bias_add", SPInstruction.SPType.Dnn);
        String2SPInstructionType.put("maxpooling", SPInstruction.SPType.Dnn);
        String2SPInstructionType.put("relu_maxpooling", SPInstruction.SPType.Dnn);
        String2SPInstructionType.put("rightIndex", SPInstruction.SPType.MatrixIndexing);
        String2SPInstructionType.put("leftIndex", SPInstruction.SPType.MatrixIndexing);
        String2SPInstructionType.put("mapLeftIndex", SPInstruction.SPType.MatrixIndexing);
        String2SPInstructionType.put("r'", SPInstruction.SPType.Reorg);
        String2SPInstructionType.put("rev", SPInstruction.SPType.Reorg);
        String2SPInstructionType.put("rdiag", SPInstruction.SPType.Reorg);
        String2SPInstructionType.put("rshape", SPInstruction.SPType.MatrixReshape);
        String2SPInstructionType.put("rsort", SPInstruction.SPType.Reorg);
        String2SPInstructionType.put("+", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("-", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("*", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("/", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("%%", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("%/%", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("1-*", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("^", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("^2", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("*2", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map+", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map-", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map*", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map/", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map%%", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map%/%", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map1-*", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map^", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map+*", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map-*", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("dropInvalidType", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapdropInvalidLength", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("_map", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("==", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("!=", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("<", SPInstruction.SPType.Binary);
        String2SPInstructionType.put(">", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("<=", SPInstruction.SPType.Binary);
        String2SPInstructionType.put(">=", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map>", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map>=", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map<", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map<=", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map==", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map!=", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("&&", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("||", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("xor", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("bitwAnd", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("bitwOr", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("bitwXor", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("bitwShiftL", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("bitwShiftR", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("!", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("map&&", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("map||", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapxor", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapbitwAnd", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapbitwOr", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapbitwXor", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapbitwShiftL", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapbitwShiftR", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("max", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("min", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapmax", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("mapmin", SPInstruction.SPType.Binary);
        String2SPInstructionType.put("rblk", SPInstruction.SPType.Reblock);
        String2SPInstructionType.put("csvrblk", SPInstruction.SPType.CSVReblock);
        String2SPInstructionType.put("libsvmrblk", SPInstruction.SPType.LIBSVMReblock);
        String2SPInstructionType.put("chkpoint", SPInstruction.SPType.Checkpoint);
        String2SPInstructionType.put("compress", SPInstruction.SPType.Compression);
        String2SPInstructionType.put("decompress", SPInstruction.SPType.DeCompression);
        String2SPInstructionType.put("log", SPInstruction.SPType.Builtin);
        String2SPInstructionType.put("log_nz", SPInstruction.SPType.Builtin);
        String2SPInstructionType.put("exp", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("abs", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("sin", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("cos", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("tan", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("asin", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("acos", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("atan", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("sinh", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("cosh", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("tanh", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("sign", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("sqrt", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("plogp", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("round", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("ceil", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("floor", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("sprop", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("sigmoid", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("detectSchema", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("colnames", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("isna", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("isnan", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("isinf", SPInstruction.SPType.Unary);
        String2SPInstructionType.put("groupedagg", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("mapgroupedagg", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("rmempty", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("replace", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("rexpand", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("lowertri", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("uppertri", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("tokenize", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("transformapply", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("transformdecode", SPInstruction.SPType.ParameterizedBuiltin);
        String2SPInstructionType.put("transformencode", SPInstruction.SPType.MultiReturnBuiltin);
        String2SPInstructionType.put("mappend", SPInstruction.SPType.MAppend);
        String2SPInstructionType.put("rappend", SPInstruction.SPType.RAppend);
        String2SPInstructionType.put("gappend", SPInstruction.SPType.GAppend);
        String2SPInstructionType.put("galignedappend", SPInstruction.SPType.GAlignedAppend);
        String2SPInstructionType.put("cbind", SPInstruction.SPType.BuiltinNary);
        String2SPInstructionType.put("rbind", SPInstruction.SPType.BuiltinNary);
        String2SPInstructionType.put("nmin", SPInstruction.SPType.BuiltinNary);
        String2SPInstructionType.put("nmax", SPInstruction.SPType.BuiltinNary);
        String2SPInstructionType.put("n+", SPInstruction.SPType.BuiltinNary);
        String2SPInstructionType.put("rand", SPInstruction.SPType.Rand);
        String2SPInstructionType.put("seq", SPInstruction.SPType.Rand);
        String2SPInstructionType.put("sample", SPInstruction.SPType.Rand);
        String2SPInstructionType.put("frame", SPInstruction.SPType.Rand);
        String2SPInstructionType.put("ctable", SPInstruction.SPType.Ctable);
        String2SPInstructionType.put("ctableexpand", SPInstruction.SPType.Ctable);
        String2SPInstructionType.put("+*", SPInstruction.SPType.Ternary);
        String2SPInstructionType.put("-*", SPInstruction.SPType.Ternary);
        String2SPInstructionType.put("ifelse", SPInstruction.SPType.Ternary);
        String2SPInstructionType.put("mapwsloss", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("redwsloss", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("mapwsigmoid", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("redwsigmoid", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("mapwdivmm", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("redwdivmm", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("mapwcemm", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("redwcemm", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("mapwumm", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("redwumm", SPInstruction.SPType.Quaternary);
        String2SPInstructionType.put("ucumack+", SPInstruction.SPType.CumsumAggregate);
        String2SPInstructionType.put("ucumac*", SPInstruction.SPType.CumsumAggregate);
        String2SPInstructionType.put("ucumac+*", SPInstruction.SPType.CumsumAggregate);
        String2SPInstructionType.put("ucumacmin", SPInstruction.SPType.CumsumAggregate);
        String2SPInstructionType.put("ucumacmax", SPInstruction.SPType.CumsumAggregate);
        String2SPInstructionType.put("bcumoffk+", SPInstruction.SPType.CumsumOffset);
        String2SPInstructionType.put("bcumoff*", SPInstruction.SPType.CumsumOffset);
        String2SPInstructionType.put("bcumoff+*", SPInstruction.SPType.CumsumOffset);
        String2SPInstructionType.put("bcumoffmin", SPInstruction.SPType.CumsumOffset);
        String2SPInstructionType.put("bcumoffmax", SPInstruction.SPType.CumsumOffset);
        String2SPInstructionType.put("cm", SPInstruction.SPType.CentralMoment);
        String2SPInstructionType.put("cov", SPInstruction.SPType.Covariance);
        String2SPInstructionType.put("qsort", SPInstruction.SPType.QSort);
        String2SPInstructionType.put("qpick", SPInstruction.SPType.QPick);
        String2SPInstructionType.put("binuaggchain", SPInstruction.SPType.BinUaggChain);
        String2SPInstructionType.put("write", SPInstruction.SPType.Write);
        String2SPInstructionType.put("castdtm", SPInstruction.SPType.Cast);
        String2SPInstructionType.put("castdtf", SPInstruction.SPType.Cast);
        String2SPInstructionType.put("spoof", SPInstruction.SPType.SpoofFused);
    }
}

